% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.interview_design}
\alias{amber.interview_design}
\title{Get an interview design}
\usage{
amber.interview_design(amber, id, study = NULL, query = list())
}
\arguments{
\item{amber}{An Amber object}

\item{id}{Interview design's name or identifier}

\item{study}{Study identifier (name or id), optional.}

\item{query}{A search query}
}
\value{
An interview design object as a named list
}
\description{
Get an interview design by its name or identifier.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.interview_design(a, id = "Adult trauma - baseline")
amber.interview_design(a, id = "61e69a22fea2df2f3108b508")
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
