% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_lagged}
\alias{calc_lagged}
\title{Calculate temporally lagged covariates}
\usage{
calc_lagged(from, date, lag, locs_id, time_id = "time", geom = FALSE)
}
\arguments{
\item{from}{data.frame(1). A \code{data.frame} containing calculated covariates
returned from \code{calculate_covariates()} or \code{calc_*()}.}

\item{date}{character(2). Start and end dates of desired lagged covariates.
Length of 10 each, format YYYY-MM-DD (ex. September 1, 2023 = "2023-09-01").}

\item{lag}{integer(1). Number of lag days.}

\item{locs_id}{character(1). Name of unique identifier.}

\item{time_id}{character(1). Column containing time values.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.} To return as a \code{SpatVector}, \code{from} must also be a \code{SpatVector}}
}
\value{
a \code{data.frame} object
}
\description{
The \code{calc_lagged()} function calculates daily temporal lagged covariates
from the output of \code{calculate_covariates()} or \code{calc_*()}.
}
\note{
In order to calculate temporally lagged covariates, \code{from} must contain at
least the number of lag days before the desired start date. For example, if
\verb{date = c("2024-01-01", "2024-01-31)} and \code{lag = 1}, \code{from} must contain data
starting at 2023-12-31.
If \code{from} contains geometry features, \code{calc_lagged} will return a column
with geometry features of the same name.
\code{calc_lagged()} assumes that all columns other than \code{time_id},
\code{locs_id}, and fixed columns of "lat" and "lon", follow the genre, variable,
lag, buffer radius format adopted in \code{calc_setcolumns()}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
terracliamte_covar <- calc_terraclimate(
  from = terraclimate, # derived from process_terraclimate() example
  locs = loc,
  locs_id = "id",
  radius = 0,
  fun = "mean",
  geom = FALSE
)
calc_lagged(
  from = terracliamte_covar,
  locs_id = "id",
  date = c("2023-01-02", "2023-01-10"),
  lag = 1,
  time_id = "time"
)
}
}
\seealso{
\code{\link[=calc_covariates]{calc_covariates()}}
}
