% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{plot_category_projections}
\alias{plot_category_projections}
\title{Plot Category Projections in MCA Space}
\usage{
plot_category_projections(
  fit,
  K,
  alpha_vec = NULL,
  dim_pair = c(1, 2),
  cex = 0.8,
  top_n = 15
)
}
\arguments{
\item{fit}{MCA fit object (class \code{mca_fit})}

\item{K}{Number of dimensions in retained subspace}

\item{alpha_vec}{Optional aggregated direction vector (from \code{alsi()})}

\item{dim_pair}{Integer vector of length 2, dimensions to plot (default: c(1,2))}

\item{cex}{Character expansion for labels}

\item{top_n}{Number of top categories to display by projection (default: 15)}
}
\value{
No return value, called for side effects. The function creates 
a scatter plot of category coordinates in the specified 2D subspace, 
with category labels displayed. If \code{alpha_vec} is provided, it also 
prints the top categories ranked by their absolute projection onto the 
ALSI direction to the console.
}
\description{
Visualizes category coordinates in a 2D MCA subspace and optionally
displays projections onto the aggregated ALSI direction.
}
