% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{matthews}
\alias{matthews}
\title{Compute Matthews Correlation Coefficient}
\usage{
matthews(predicted, y, positive)
}
\arguments{
\item{predicted}{numeric. the predicted value of binary classification}

\item{y}{factor or character. the actual value of binary classification}

\item{positive}{level of positive class of binary classification}
}
\value{
numeric. The Matthews Correlation Coefficient.
}
\description{
compute the Matthews correlation coefficient with actual and predict values.
}
\details{
The Matthews Correlation Coefficient has a value between -1 and 1, and the closer to 1,
the better the performance of the binary classification.
}
\examples{
# simulate actual data
set.seed(123L)
actual <- sample(c("Y", "N"), size = 100, prob = c(0.3, 0.7), replace = TRUE)
actual

# simulate predict data
set.seed(123L)
pred <- sample(c("Y", "N"), size = 100, prob = c(0.2, 0.8), replace = TRUE)
pred

# simulate confusion matrix
table(pred, actual)

matthews(pred, actual, "Y")
}
