% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/xrd.R
\docType{methods}
\name{ka2_strip_penalized}
\alias{ka2_strip_penalized}
\alias{ka2_strip_penalized-method}
\alias{ka2_strip_penalized,numeric,numeric-method}
\alias{ka2_strip_penalized,ANY,missing-method}
\title{Strip XRD ka2}
\usage{
ka2_strip_penalized(x, y, ...)

\S4method{ka2_strip_penalized}{numeric,numeric}(
  x,
  y,
  lambda,
  wave = c(1.5406, 1.54443),
  tau = 0.5,
  nseg = 1,
  progress = interactive()
)

\S4method{ka2_strip_penalized}{ANY,missing}(
  x,
  lambda,
  wave = c(1.5406, 1.54443),
  tau = 0.5,
  nseg = 1,
  progress = interactive()
)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{lambda}{An \code{\link{integer}} giving the smoothing parameter. The larger
\code{lambda} is, the smoother the curve.}

\item{wave}{A length-two \code{\link{numeric}} vector giving the characteristic
wavelengths of the anode material (defaults to copper).}

\item{tau}{A length-one \code{\link{numeric}} vector giving the ratio between
\eqn{\alpha}1 and \eqn{\alpha}2 line intensities (defaults to 1/2).}

\item{nseg}{A length-one \code{\link{numeric}} vector specifying the number of equally
sized segments for B-spline basis matrix computation.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Strip XRD ka2
}
\note{
\pkg{Matrix} is required.
}
\examples{
\dontrun{
## X-ray diffraction
data("XRD")

## Subset from 20 to 40 degrees
XRD <- signal_select(XRD, from = 20, to = 40)

## Plot diffractogram
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Penalized likelihood smoothing
lambda <- seq(from = 1, to = 8, length.out = 40)
lambda <- 10^lambda

likelihood <- smooth_likelihood(XRD, lambda = lambda, d = 3)
lines(likelihood, col = "red")

## Strip ka2
ka2 <- ka2_strip_penalized(XRD, lambda = lambda, tau = 0.5, nseg = 1)
lines(ka2, col = "blue")
}
}
\references{
de Rooi, J. J., van der Pers, N. M., Hendrikx, R. W. A., Delhez, R.,
Böttger A. J. and Eilers, P. H. C. (2014). Smoothing of X-ray diffraction
data and Ka2 elimination using penalized likelihood and the composite link
model. \emph{Journal of Applied Crystallography}, 47: 852-860.
\doi{10.1107/S1600576714005809}
}
\author{
J. J. de Rooi \emph{et al.} (original R code).
}
\concept{specialized tools}
