% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spp_list_algaebase.r
\name{spp_list_algaebase}
\alias{spp_list_algaebase}
\title{Wrapper for applying algae_search function to a data.frame that contains phytoplankton species}
\usage{
spp_list_algaebase(phyto.df, phyto.name = 1, lakename = "",
  long = FALSE, write = FALSE)
}
\arguments{
\item{phyto.df}{data.frame containing a character column with binomial names}

\item{phyto.name}{Name or number of column that contains binomial names}

\item{lakename}{Character string for naming output files}

\item{long}{TRUE/FALSE: should higher taxonomy (Kingdom:Family) be included in output?}

\item{write}{TRUE/FALSE: should output be written as .csv file?}
}
\value{
A data.frame with the following fields: orig.name (submitted name),
    match.name (best match), genus and species (from the match.name), exact.match (1
    indicates whether there was a perfect match for orig.name. 0 otherwise),
    accepted (1 if the orig.name currently accepted, 0 otherwise),
    synonyms (currently accepted synonyms, if any. For genus-only search, returns
    genera associated with species formerly classified with the orig.name genus)
    Empire,Kingdom,Phylum,Class,Order,Family: character strings with current higher
    taxonomy associated with match.name
}
\description{
Wrapper for applying algae_search function to a data.frame that contains phytoplankton species
}
\examples{
data(lakegeneva)
lakegeneva=lakegeneva[1,] ##use 1 row for testing
lakegeneva.algaebase<-
spp_list_algaebase(lakegeneva,phyto.name='phyto_name',long=FALSE,write=FALSE)

}
\seealso{
\url{http://www.algaebase.org} for up-to-date phytoplankton taxonomy,
    \url{https://powellcenter.usgs.gov/geisha} for project information.
	Algaebase should be cited separately in any publications using this function:
    <doi:10.7872/crya.v35.iss2.2014.105>
}
