% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa4alBoot.R
\name{kappa4alBoot}
\alias{kappa4alBoot}
\alias{kappa4alBoot.default}
\alias{print.kappa4alBoot}
\alias{summary.kappa4alBoot}
\alias{print.summary.kappa4alBoot}
\alias{kappa4alBoot.formula}
\alias{predict.kappa4alBoot}
\title{Sigmoidal curve fitting.}
\usage{
kappa4alBoot(formula, data = list(), xin, lower, upper, q1, q2, tol, maxiter,
  bootstraps, bootName, ...)

\method{kappa4alBoot}{default}(formula, data = list(), xin, lower = c(0, -5,
  -5), upper = c(10, 1, 1), q1, q2, tol = 1e-15, maxiter = 50000,
  bootstraps, bootName, ...)

\method{print}{kappa4alBoot}(x, ...)

\method{summary}{kappa4alBoot}(object, ...)

\method{print}{summary.kappa4alBoot}(x, ...)

\method{kappa4alBoot}{formula}(formula, data = list(), xin, lower, upper, q1,
  q2, tol, maxiter, bootstraps, bootName, ...)

\method{predict}{kappa4alBoot}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length 3 containing initial values, for \eqn{\sigma}, \eqn{h}, and \eqn{k}.}

\item{lower}{A vector of lower constraints for the parameters to be estimated; defaults to c(0, -5, -5).}

\item{upper}{A vector of upper constraints for the parameters to be estimated; defaults to c(10, 1, 1).}

\item{q1, q2}{Numeric vectors, for the lower and upper bounds of the intervals over which arc lengths are to be computed.}

\item{tol}{Error tolerance level; defaults to 1e-15.}

\item{maxiter}{The maximum number of iterations allowed; defaults to 50000.}

\item{bootstraps}{An integer giving the number of bootstrap samples.}

\item{bootName}{The name of the .rds file to store the kappa4alBoot object.  May include a path.}

\item{...}{Arguments to be passed on to the differential evolution function \code{\link{JDEoptim}}.}

\item{x}{A kappa4alBoot object.}

\item{object}{A kappa4alBoot object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class kappa4alBoot.

kappa4alBoot.default: A list object (saved using \code{saveRDS} in the specified location) with the following components:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item bcoefficients: A vector of bootstrap coefficients, resulting from bootstrap estimation.
\item se: The standard errors for the estimates resulting from bootstrap estimation.
\item error: The value of the objective function.
\item errorList: A vector of values of the objective function for each bootstrap sample.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
}

summary.kappa4alBoot: A list of class summary.kappa4alBoot with the following components:
\itemize{
\item call: Original call to the \code{kappa4alBoot} function.
\item coefficients: A matrix with estimates, estimated errors, and 95\% parameter confidence intervals (based on the inverse empirical distribution function).
\item arclengths: A matrix of the arc length segments that were matched, for the dependent and independent variables.
\item r.squared: The \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item error: Value of the objective function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
\item residSum: Summary statistics for the distribution of the residuals.
\item errorSum: Summary statistics for the distribution of the value of the objective function.
}

print.summary.kappa4alBoot: The object passed to the function is returned invisibly.

predict.kappa4alBoot: A vector of predicted values resulting from the estimated model.
}
\description{
Bootstrap estimates, along with standard  errors and confidence intervals, of a nonlinear model, resulting from  arc length fitting of the four-parameter kappa sigmoidal function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for kappa4alBoot.

\item \code{kappa4alBoot}: print method for kappa4alBoot.

\item \code{kappa4alBoot}: summary method for kappa4alBoot.

\item \code{summary.kappa4alBoot}: print method for summary.kappa4alBoot.

\item \code{formula}: formula method for kappa4alBoot.

\item \code{kappa4alBoot}: predict method for kappa4alBoot.
}}

