% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alKDE.R
\name{alKDE}
\alias{alKDE}
\alias{alKDE.default}
\alias{print.alKDE}
\alias{summary.alKDE}
\alias{print.summary.alKDE}
\alias{alKDE.formula}
\alias{predict.alKDE}
\title{Arc length matching for kernel density estimators.}
\usage{
alKDE(formula, data = list(), xin, q1, q2, type, ...)

\method{alKDE}{default}(formula, data = list(), xin, q1, q2, type, ...)

\method{print}{alKDE}(x, ...)

\method{summary}{alKDE}(object, ...)

\method{print}{summary.alKDE}(x, ...)

\method{alKDE}{formula}(formula, data = list(), xin, q1, q2, type, ...)

\method{predict}{alKDE}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length equal to the number of independent variables, of initial values, for the parameters to be estimated.}

\item{q1, q2}{Numeric vectors, for the lower and upper bounds of the intervals over which arc lengths are to be computed.}

\item{type}{An integer specifying the bandwidth selection method, see \code{\link{bw}}.}

\item{...}{Arguments to be passed on to the control argument of the \code{\link{optim}} function.}

\item{x}{An alKDE object.}

\item{object}{An alKDE object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class alKDE.

alKDE.default: A list with all components from \code{\link{optim}}, as well as:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item df: Degrees of freedom of the model.
\item error: The value of the objective function.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item h_y: The KDE bandwidth estimator for the dependent variable.
\item h_X: The KDE bandwidth estimator for the independent variables, i.e. \eqn{\mathbf{X}\underline{\hat{\beta}}}.
\item ALy: Arc length segments of the KDE cast over the dependent variable.
\item ALX: Arc length segments of the KDE cast over the independent variables \eqn{\mathbf{X}\underline{\hat{\beta}}}.
p1: The vector of quantiles in the domain of \eqn{y} corresponding to \code{q1}.
p2: The vector of quantiles in the domain of \eqn{y} corresponding to \code{q2}.
}

summary.alKDE: A list of class summary.alKDE with the following components:
\itemize{
\item call: Original call to the \code{alKDE} function.
\item coefficients: A vector with parameter estimates.
\item arclengths: A matrix of the arc length segments of the dependent and independent variables that were matched.  The final row corresponds to the estimated bandwidth parameters for each, i.e. \code{h_y} and \code{h_X}, respectively.
\item r.squared: The \eqn{r^{2}} coefficient.
\item adj.r.squared: The adjusted \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item df: Degrees of freedom for the model.
\item error: Value of the objective function.
\item residSum: Summary statistics for the distribution of the residuals.
}

print.summary.alKDE: The object passed to the function is returned invisibly.

predict.alKDE: A vector of predicted values resulting from the estimated model.
}
\description{
Estimate parameters of a linear model by matching the arc lengths of kernel density estimators.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for alKDE.

\item \code{alKDE}: print method for alKDE.

\item \code{alKDE}: summary method for alKDE.

\item \code{summary.alKDE}: print method for summary.alKDE.

\item \code{formula}: formula method for alKDE.

\item \code{alKDE}: predict method for alKDE.
}}

\examples{
x <- 1:10
y <- x+rnorm(10)
XIn <- lm(y~x)
alKDE(y~x, xin=coef(XIn), q1=c(0.025,0.5), q2=c(0.5,0.975), type=-1)

u <- 11:20
v <- u+rnorm(10)
XIn <- lm(y~x)
al <- alKDE(y~x, xin=coef(XIn), q1=c(0.025,0.5), q2=c(0.5,0.975), type=-1)
predict(al, newdata=data.frame(y=v, x=u))

}
