% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tensor_to_matrix_c}
\alias{tensor_to_matrix_c}
\title{Transform tensor to matrix}
\usage{
tensor_to_matrix_c(tensor, times, features)
}
\arguments{
\item{tensor}{\verb{3-D array (cube)} data as tensor (with size batch x times x features)}

\item{times}{\verb{unsigned integer} times number}

\item{features}{\verb{unsigned integer} features number}
}
\value{
Returns matrix (with size batch x times*features)
}
\description{
Function written in C++ for transformation the tensor (with size batch x times x features) to the matrix (with
size batch x times*features)
}
\seealso{
Other Utils Developers: 
\code{\link{auto_n_cores}()},
\code{\link{create_object}()},
\code{\link{create_synthetic_units_from_matrix}()},
\code{\link{generate_id}()},
\code{\link{get_n_chunks}()},
\code{\link{get_synthetic_cases_from_matrix}()},
\code{\link{get_time_stamp}()},
\code{\link{matrix_to_array_c}()},
\code{\link{to_categorical_c}()}
}
\concept{Utils Developers}
