% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_main.R
\name{fit}
\alias{fit}
\title{fit}
\usage{
fit(Sigma, n, eta, maxIter = 2000)
}
\arguments{
\item{Sigma}{a list with two data frames. One for the inputs X, and one for the outputs Y.}

\item{n}{number of particles to use.}

\item{eta}{learning rate of the algorithm. Default is \code{0.01}.}

\item{maxIter}{maximum number of iterations.}
}
\value{
an object of class "\code{ahn}" with the following components:
\itemize{
        \item network: structure of the AHN trained.
        \item Yo: original output variable.
        \item Ym: predicted output variable.
        \item eta: learning rate.
        \item minOverallError: minimum error achieved.
        \item variableNames: names of the input variables.
}
}
\description{
Function to train an Artificial Hydrocarbon Network (AHN).
}
\examples{
# Create data
x <- 2 * runif(1000) - 1;
x <- sort(x)

y <- (x < 0.1) * (0.05 * runif(100) + atan(pi*x)) +
    (x >= 0.1 & x < 0.6) * (0.05 * runif(1000) + sin(pi*x)) +
    (x >= 0.6) * (0.05 * runif(1000) + cos(pi*x))

# Create Sigma list
Sigma <- list(X = data.frame(x = x), Y = data.frame(y = y))

# Train AHN
ahn <- fit(Sigma, 5, 0.01, 500)

}
