% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzylogic-tnorm.R
\name{tnorm_minimum}
\alias{tnorm_minimum}
\alias{tnorm_product}
\alias{tnorm_lukasiewicz}
\alias{tnorm_drastic}
\alias{tnorm_fodor}
\title{t-norms}
\usage{
tnorm_minimum(x, y)

tnorm_product(x, y)

tnorm_lukasiewicz(x, y)

tnorm_drastic(x, y)

tnorm_fodor(x, y)
}
\arguments{
\item{x}{numeric vector with elements in \eqn{[0,1]}}

\item{y}{numeric vector of the same length as \code{x},
with elements in \eqn{[0,1]}}
}
\value{
Numeric vector of the same length as \code{x} and \code{y}.
The \code{i}th element of the resulting vector gives the result
of calculating \code{T(x[i], y[i])}.
}
\description{
Various t-norms.
Each of these is a fuzzy logic generalization
of the classical conjunction operation.
}
\details{
A function \eqn{T: [0,1]\times [0,1]\to [0,1]}
is a \emph{t-norm} if for all \eqn{x,y,z\in [0,1]} it holds:
(a) \eqn{T(x,y)=T(y,x)};
(b) if \eqn{y\le z}, then \eqn{T(x,y)\le T(x,z)};
(c) \eqn{T(x,T(y,z))=T(T(x,y),z)};
(d) \eqn{T(x, 1)=x}.

The minimum t-norm is given by \eqn{T_M(x,y)=min(x, y)}.

The product t-norm is given by \eqn{T_P(x,y)=xy}.

The Lukasiewicz t-norm is given by \eqn{T_L(x,y)=max(x+y-1,0)}.

The drastic t-norm is given by \eqn{T_D(x,y)=0} iff
\eqn{x,y\in [0,1)}, and \eqn{min(x, y)} otherwise.

The Fodor t-norm is given by \eqn{T_F(x,y)=0}
iff \eqn{x+y \le 1}, and \eqn{min(x, y)} otherwise.
}
\references{
Klir G.J, Yuan B., \emph{Fuzzy sets and fuzzy logic. Theory and applications},
Prentice Hall PTR, New Jersey, 1995.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other fuzzy_logic: \code{\link{fimplication_minimal}},
  \code{\link{fnegation_yager}},
  \code{\link{tconorm_minimum}}
}
\concept{fuzzy_logic}
