% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{sample_marginal}
\alias{sample_marginal}
\title{Sample from the mixture-of-Gaussians approximation to the marginal posterior of the "inner"
variables from a marginal Laplace approximation.}
\usage{
sample_marginal(quad, M, ...)
}
\arguments{
\item{quad}{The result of running \code{aghq::marginal_laplace}, object of class
\code{marginallaplace} from which to draw samples.}

\item{M}{Numeric, integer saying how many samples to draw}

\item{...}{Not used}
}
\value{
A list containing elements:
\itemize{
\item{\code{samps}: }{ \code{d x M} matrix where \code{d = dim(W)} and each column is a sample
from \code{pi(W|Y,theta)}}
\item{\code{theta}: }{\code{M x S} tibble where \code{S = dim(theta)} containing the value of \code{theta} for
each sample}
}
}
\description{
Draws samples from the mixture-of-Gaussians approximation to the variables that were
marginalized over in a marginal Laplace approximation fit using \code{aghq::marginal_laplace}.
Computes the Choleskies once and then draws as many samples as you ask, quickly.
}
\details{
This method samples from the posterior and returns a vector that is ordered
the same as the "W" variables in your marginal Laplace approximation. If your
model contains more than one type of variable that is being marginalized over,
it is up to you to subset these out of W. See the \code{aghq} package software
paper for several examples.
}
\concept{sampling}
