% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{causal_ols_rpart}
\alias{causal_ols_rpart}
\title{Estimating Leaf-Effects via Linear Models}
\usage{
causal_ols_rpart(tree, y, X, D, method = "aipw", scores = NULL)
}
\arguments{
\item{tree}{An \code{\link[rpart]{rpart}} object.}

\item{y}{Outcome vector.}

\item{X}{Covariate matrix (no intercept).}

\item{D}{Treatment assignment vector}

\item{method}{Either \code{"raw"} or \code{"aipw"}, defines the outcome used in the regression.}

\item{scores}{Optional, vector of scores to be used in the regression. Useful to save computational time if scores have already been estimated. Ignored if \code{method == "raw"}.}
}
\value{
The fitted model, as an \code{\link[estimatr]{lm_robust}} object, and the scores (if \code{method == "raw"}, this is
\code{NULL}).
}
\description{
Uses the leaves of a tree stored in an \code{\link[rpart]{rpart}} object to estimate a linear model via OLS. The
estimated coefficients identify the GATE in each leaf. If the data used in the OLS estimation have not been
used to grow the tree (a condition called "honesty"), then one can use the standard errors for the tree's estimates
to construct valid confidence intervals.
}
\details{
The \code{method} argument controls how GATEs are estimated. If \code{"method" == "raw"}, we estimate via OLS the following
linear model:

\deqn{Y_i = \sum_{l = 1}^{|T|} L_{i, l} \gamma_l + \sum_{l = 1}^{|T|} L_{i, l} D_i \beta_l + \epsilon_i}

with \code{L_{i, l}} a dummy variable equal to one if the i-th unit falls in the l-th leaf of the tree, and \code{|T|} the
number of leaves. If the treatment is randomly assigned, one can show that the betas identify the GATE of each group.
Thus, we can interpret the OLS results as usual. However, in observational studies these estimates are biased
due to selection into treatment. To get unbiased estimates, we can set \code{"method"} to \code{"aipw"} to construct
doubly-robust scores \code{y_i^*} and use them as a pseudo-outcome in the following regression:

\deqn{Y_i^* = \sum_{l = 1}^{|T|} L_{i, l} \beta_l + \epsilon_i}

This way, we get unbiased GATEs estimates, and we can again interpret OLS results as usual. Honest regression forests
and 5-fold cross fitting are used to estimate the propensity score and the conditional mean function of the outcome
(unless the user specifies the argument \code{scores}).\cr

Notice that "honesty" is a necessary requirement to get valid inference. Thus, observations in \code{y}, \code{D}, and
\code{X} must not have been used to grow the \code{tree}.\cr

Regardless of \code{method}, standard errors are estimated via the Eicker-Huber-White estimator.\cr

If \code{tree} consists of a root only, \code{causal_ols_rpart} regresses \code{y} on a constant and \code{D} if
\code{method == "raw"}, or regresses the doubly-robust scores on a constant if \code{method == "aipw"}. This way,
we get an estimate of the ATE.
}
\references{
\itemize{
  \item R Di Francesco (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{estimate_rpart}} \code{\link{avg_characteristics_rpart}}
}
\author{
Riccardo Di Francesco
}
