% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvaft.R
\name{pvaft}
\alias{pvaft}
\title{Estimates of univariate covariates using Accelerated Failure time (AFT) model without MCMC.}
\usage{
pvaft(m, n, STime, Event, p = 1, data)
}
\arguments{
\item{m}{Starting column number of covariates of study in high dimensional entered data.}

\item{n}{Ending column number of covariates of study in high dimensional entered data.}

\item{STime}{name of survival time in data.}

\item{Event}{name of event in data. 0 is for censored and 1 for occurrence of event.}

\item{p}{p-value, to make restriction for selection of covariates, default value is 1.}

\item{data}{High dimensional gene expression data that contains event status, survival time and and set of covariates.}
}
\value{
Matrix that contains survival information of selected covariates(selected from chosen columns whose p value is <= p) on AFT model. Result shows together for all covariates chosen from column m to n.
}
\description{
Provides list of covariates and their estimates of parametric AFT model with smooth time functions, whose p value is less than chosen value (by default p=1 that is all chosen covariates come in result). Using AFT model for univariate in high dimensional data without MCMC.
}
\details{
Survival time T for covariate x, is modelled as AFT model using
\deqn{S(T|x)=S_0(T\exp(-\eta(x;\beta)))}
and baseline survival function is modelled as
\deqn{S_0(T)=\exp(-\exp(\eta_0(log(T);\beta_0)))}
Where \eqn{\eta} and \eqn{\eta} are linear predictor.
}
\examples{
##
data(hdata)
pvaft(9,30,STime="os",Event="death",0.1,hdata)
##
}
\seealso{
wbysuni,wbysmv, rglaft
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
