\name{afc.mm}
\alias{afc.mm}
\title{ 2AFC For Ordinal Polychotomous Observations And Ordinal Polychotomous Forecasts }
\description{
 Routine to calculate the Generalized Discrimination Score (aka
 Two-Alternatives Forced Choice Score 2AFC) for the situation of
 polychotomous observations (ordinal) and polychotomous forecasts (ordinal)
}
\usage{
afc.mm(obsv, fcst, mv = 3, mf = 3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{obsv}{ vector with polychotomous observations (values in
  \{1,..,mv\}) }
  \item{fcst}{ vector of same length as \emph{obsv} with polychotomous
  forecasts (values in \{1,..,mf\}) }
  \item{mv}{ number of observation categories (default = 3) }
  \item{mf}{ number of forecast categories (default = 3) }
}
\details{
  This routine applies Eq.14 of Mason and Weigel (2009) to calculate the 2AFC.
}
\value{
  \item{ p.afc }{ Value of Generalized Discrimination (2AFC) Score }
}
\references{ S.J. Mason and A.P. Weigel, 2009. A generic verification
  framework for administrative purposes. Mon. Wea. Rev., 137, 331-349 }
\author{ Andreas Weigel, Federal Office of Meteorology and Climatology,
  MeteoSwiss, Zurich, Switzerland }
\seealso{ \code{\link{afc}} }
\examples{
  #Forecasts and observations of Nino-3.4 index
  #Load set of polychotomous observations (4 categories) and polychotomous forecasts (4 categories)
  data(cnrm.nino34.mm)
  obsv = cnrm.nino34.mm$obsv
  fcst = cnrm.nino34.mm$fcst

  #Calculate skill score
  afc.mm(obsv,fcst,4,4)
}
\keyword{ file }% at least one, from doc/KEYWORDS
