% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.aedseo}
\alias{summary.aedseo}
\title{Summary method for aedseo objects}
\usage{
\method{summary}{aedseo}(object, ...)
}
\arguments{
\item{object}{An object of class 'aedseo' containing the results of an aedseo
analysis.}

\item{...}{Additional arguments (not used).}
}
\value{
This function is used for its side effect, which is printing a
summary message to the console.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize the results of an aedseo analysis, including the latest growth rate
estimate, the confidence interval, and information about growth warnings.
}
\examples{
# Create a tsibble object from sample data
tsd_data <- tsd(
  observed = c(100, 120, 150, 180, 220, 270),
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  time_interval = "day"
)

# Calculate aedseo with a 3-day window and a Poisson family model
aedseo_results <- aedseo(
  tsd = tsd_data,
  k = 3,
  level = 0.95,
  family = "poisson"
)
# Print the summary of the aedseo_results to the console
summary(aedseo_results)
}
