% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aeddo.R
\name{aeddo}
\alias{aeddo}
\title{Automated and Early Detection of Disease Outbreaks}
\usage{
aeddo(
  data = data.frame(),
  formula = formula(),
  k = integer(),
  sig_level = 0.95,
  exclude_past_outbreaks = TRUE,
  init_theta = numeric(),
  lower = numeric(),
  upper = numeric(),
  method = "BFGS"
)
}
\arguments{
\item{data}{A tibble containing the time series data, including columns 'y'
for observed values,'n' for population size, and other covariates of
interest.}

\item{formula}{A model formula for the fixed effects in the  hierarchical
model to fit to the data.}

\item{k}{An integer specifying the rolling window size employed for parameter
estimation.}

\item{sig_level}{The quantile from the random effects distribution used for
defining the for outbreak detection threshold, a numeric value between 0 and
1.}

\item{exclude_past_outbreaks}{logical value indicating whether past outbreak
related observations should be excluded from future parameter estimation.}

\item{init_theta}{Initial values for model parameters in optimization.}

\item{lower}{Lower bounds for optimization parameters.}

\item{upper}{Upper bounds for optimization parameters.}

\item{method}{The optimization method to use, either "BFGS"  (default) or
"L-BFGS-B".}
}
\value{
A \link[tibble:tibble-package]{tibble}-like 'aedseo' object containing:
\itemize{
\item 'window_data': A list of \link[tibble:tibble-package]{tibble}, each
representing the data for this windowed parameter estimation.
\item 'reference_data': A list of \link[tibble:tibble-package]{tibble}, each
representing the data for the reference time point.
\item 'phi': The dispersion parameter.
\item 'lambda': The estimated outbreak intensity.
\item 'u': The one-step ahead random effect.
\item 'u_probability': The probability of observing the one-step ahead
random effect.
\item 'outbreak_alarm': Logical. Indicates if an outbreak is detected.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function performs automated an early detection of disease outbreaks,
(aeddo), on a time series data set. It utilizes hierarchical models in an
innovative manner to infer one-step ahead random effects. In turn, these
random effects are used directly to characterize an outbreak.
}
\examples{
# Create an example aedseo_tsd object
aeddo_data <- data.frame(
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  y = c(100, 120, 180, 110, 130, 140),
  n = 1
)

# Supply a model formula
fixed_effects_formula <- y ~ 1

# Choose a size for the rolling window
k <- 2
# ... and quantile for the threshold
sig_level <- 0.9

# Employ the algorithm
aeddo_results <- aeddo(
  data = aeddo_data,
  formula = fixed_effects_formula,
  k = k,
  sig_level = sig_level,
  exclude_past_outbreaks = TRUE,
  init_theta = c(1, 0),
  lower = c(-Inf, 1e-6),
  upper = c(Inf, 1e2),
  method = "L-BFGS-B"
)
# Print the results
print(aeddo_results)
}
