% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairs_admb.R
\name{pairs_admb}
\alias{pairs_admb}
\title{Plot pairwise parameter posteriors and optionally the MLE points and
confidence ellipses.}
\usage{
pairs_admb(fit, diag = c("trace", "acf", "hist"), acf.ylim = c(-1, 1),
  ymult = NULL, axis.col = gray(0.5), pars = NULL, label.cex = 0.5,
  limits = NULL, ...)
}
\arguments{
\item{fit}{A list as returned by \code{sample_admb}.}

\item{diag}{What type of plot to include on the diagonal, options are
'acf' which plots the autocorrelation function \code{acf}, 'hist'
shows marginal posterior histograms, and 'trace' the trace plot.}

\item{acf.ylim}{If using the acf function on the diagonal, specify the y
limit. The default is c(-1,1).}

\item{ymult}{A vector of length ncol(posterior) specifying how much room
to give when using the hist option for the diagonal. For use if the
label is blocking part of the plot. The default is 1.3 for all
parameters.}

\item{axis.col}{Color of axes}

\item{pars}{A vector of parameter names or integers representing which
parameters to subset. Useful if the model has a larger number of
parameters and you just want to show a few key ones.}

\item{label.cex}{Control size of labels}

\item{limits}{A list containing the ranges for each parameter to use in
plotting.}

\item{...}{Arguments to be passed to plot call in lower diagonal panels}
}
\value{
Produces a plot, and returns nothing.
}
\description{
Plot pairwise parameter posteriors and optionally the MLE points and
confidence ellipses.
}
\examples{
fit <- readRDS(system.file('examples', 'fit_admb.RDS', package='adnuts'))
pairs_admb(fit)

}
\author{
Cole Monnahan
}
