% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_test.R
\name{admix_test}
\alias{admix_test}
\title{Equality test for the unknown components of admixture models}
\usage{
admix_test(
  samples,
  admixMod,
  test_method = c("poly", "icv"),
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{samples}{A list of the K (K > 0) samples to be studied, each one assumed to follow a mixture distribution.}

\item{admixMod}{A list of objects of class \link[admix]{admix_model}, containing useful information about distributions and parameters
of the contamination / admixture models under study.}

\item{test_method}{The testing method to be applied. Can be either 'poly' (polynomial basis expansion) or 'icv' (inner
convergence from IBM). The same testing method is performed between all samples. In the one-sample case,
only 'Poly' is available and the test is a gaussianity test. For further details, see section 'Details' below.}

\item{conf_level}{The confidence level of the K-sample test.}

\item{...}{Depending on the choice made by the user for the test method ('poly' or 'icv'), optional arguments to
\link[admix]{gaussianity_test} or \link[admix]{orthobasis_test} (in case of 'poly'), and to \link[admix]{IBM_k_samples_test}
in case of 'icv'.
.}
}
\value{
An object of class \link[admix]{admix_test}, containing 8 attributes: 1) the test decision (reject the null hypothesis or not);
2) the p-value of the test; 3) the confidence level of the test (1-alpha, where alpha denotes the level of the test
or equivalently the type-I error); 4) the value of the test statistic; 5) the number of samples under study; 6) the
respective size of each sample; 7) the information about mixture components (distributions and parameters); 8) the
chosen testing method (either based on polynomial basis expansions, or on the inner convergence property; see given
references).
}
\description{
Perform hypothesis test between unknown components of a list of admixture models, where we remind that the i-th admixture
model has probability density function (pdf) l_i such that:
l_i = p_i * f_i + (1-p_i) * g_i, with g_i the known component density.
The unknown quantities p_i and f_i are thus estimated, leading to the test given by the following null and alternative hypothesis:
H0: f_i = f_j for all i != j   against H1 : there exists at least i != j such that f_i differs from f_j.
The test can be performed using two methods, either the comparison of coefficients obtained through polynomial basis expansions
of the component densities, or by the inner-convergence property obtained using the IBM approach. See 'Details' below for further information.
}
\details{
For further details on implemented hypothesis tests, see the references hereafter.
.
}
\examples{
####### Example with 2 samples
mixt1 <- twoComp_mixt(n = 380, weight = 0.7,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = -2, "sd" = 0.5),
                                        list("mean" = 0, "sd" = 1)))
mixt2 <- twoComp_mixt(n = 350, weight = 0.85,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = -2, "sd" = 0.5),
                                        list("mean" = -1, "sd" = 1)))
data1 <- getmixtData(mixt1)
data2 <- getmixtData(mixt2)
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
admixMod2 <- admix_model(knownComp_dist = mixt2$comp.dist[[2]],
                         knownComp_param = mixt2$comp.param[[2]])
admix_test(samples = list(data1,data2), admixMod = list(admixMod1,admixMod2),
           conf_level = 0.95, test_method = "poly", ask_poly_param = FALSE, support = "Real")

}
\references{
\insertRef{MilhaudPommeretSalhiVandekerkhove2024b}{admix}
\insertRef{MilhaudPommeretSalhiVandekerkhove2022}{admix}
\insertRef{PommeretVandekerkhove2019}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
