% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBM_empirical_contrast.R
\name{IBM_empirical_contrast}
\alias{IBM_empirical_contrast}
\title{Empirical computation of the contrast in the Inversion - Best Matching (IBM) method}
\usage{
IBM_empirical_contrast(
  par,
  fixed.p.X = NULL,
  sample1,
  sample2,
  G,
  comp.dist,
  comp.param
)
}
\arguments{
\item{par}{Numeric vector with two elements, corresponding to the two parameter values at which to compute the contrast. In practice
the component weights for the two admixture models.}

\item{fixed.p.X}{Arbitrary value chosen by the user for the component weight related to the unknown component of the first
admixture model. Only useful for optimization when the known components of the two models are identical
(G1=G2, leading to unidimensional optimization).}

\item{sample1}{Observations of the first sample under study.}

\item{sample2}{Observations of the second sample under study.}

\item{G}{Distribution on which to integrate when calculating the contrast.}

\item{comp.dist}{A list with four elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the two admixture models. The two first elements refer to the unknown and known components of the 1st admixture model,
and the last two ones to those of the second admixture model. If there are unknown elements, they must be specified as 'NULL' objects.
For instance, 'comp.dist' could be specified as follows: list(f1=NULL, g1='norm', f2=NULL, g2='norm').}

\item{comp.param}{A list with four elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
The two first elements refer to the parameters of unknown and known components of the 1st admixture model, and the last
two ones to those of the second admixture model. If there are unknown elements, they must be specified as 'NULL' objects.
For instance, 'comp.param' could be specified as follows: : list(f1=NULL, g1=list(mean=0,sd=1), f2=NULL, g2=list(mean=3,sd=1.1)).}
}
\value{
The empirical contrast value evaluated at parameter values.
}
\description{
Defines the empirical version of the contrast in the IBM method, to be minimized in the optimization process. For further details
about the contrast definition, see 'Details' below.
}
\details{
See the paper presenting the IBM approach at the following HAL weblink: https://hal.archives-ouvertes.fr/hal-03201760
}
\examples{
## Simulate data:
list.comp <- list(f1 = 'norm', g1 = 'norm',
                  f2 = 'norm', g2 = 'norm')
list.param <- list(f1 = list(mean = 3, sd = 0.5), g1 = list(mean = 0, sd = 1),
                   f2 = list(mean = 1, sd = 0.1), g2 = list(mean = 5, sd = 2))
sample1 <- rsimmix(n=1500, unknownComp_weight=0.5, comp.dist = list(list.comp$f1,list.comp$g1),
                                               comp.param = list(list.param$f1,list.param$g1))
sample2 <- rsimmix(n=2000, unknownComp_weight=0.7, comp.dist = list(list.comp$f2,list.comp$g2),
                                               comp.param = list(list.param$f2,list.param$g2))
## Create the distribution on which the contrast will be integrated:
G <- stats::rnorm(n = 1000, mean = sample(c(sample1[['mixt.data']], sample2[['mixt.data']]),
                                          size = 1000, replace = TRUE),
                  sd = density(c(sample1[['mixt.data']], sample2[['mixt.data']]))$bw)
## Compute the empirical contrast at parameters (p1,p2) = (0.2,0.7) in a real-life setting:
list.comp <- list(f1 = NULL, g1 = 'norm',
                  f2 = NULL, g2 = 'norm')
list.param <- list(f1 = NULL, g1 = list(mean = 0, sd = 1),
                   f2 = NULL, g2 = list(mean = 5, sd = 2))
IBM_empirical_contrast(par = c(0.2,0.7), fixed.p.X = NULL, sample1 = sample1[['mixt.data']],
           sample2= sample2[['mixt.data']], G=G, comp.dist = list.comp, comp.param = list.param)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
