% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsimmix.R
\name{rsimmix}
\alias{rsimmix}
\title{Simulation of a two-component mixture model}
\usage{
rsimmix(
  n = 1000,
  unknownComp_weight = 0.5,
  comp.dist = list(f = "norm", g = "norm"),
  comp.param = list(f = c(mean = 0, sd = 1), g = c(mean = 2, sd = 1))
)
}
\arguments{
\item{n}{Number of observations to be drawn.}

\item{unknownComp_weight}{Weight of the component distribution f (representing the unknown component in admixture models).}

\item{comp.dist}{A list with two elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the mixture model. These elements respectively refer to the two components f and g.
No unknown elements permitted. For instance, 'comp.dist' could be set equal to list(f = 'rnorm', g = 'norm').}

\item{comp.param}{A list with two elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
These elements respectively refer to the parameters of f and g distributions of the mixture model. No unknown elements permitted.
For instance, 'comp.param' could be set equal to list(f=list(mean=2,sd=0.3), g=list(mean=0,sd=1)).}
}
\value{
A list of three components. The first, named 'mixt.data', is the simulated sample from the specified mixture distribution.
The second, named 'unknown.data', refers to the data simulated corresponding to the distribution f. The third, named 'known.data',
corresponds to the observations affiliated to the known component g.
}
\description{
Simulate a two-component mixture model following the probability density function (pdf) l such that l = p*f + (1-p)*g,
with f and g mixture component distributions, and p the mixture weight.
}
\examples{
sim.X <- rsimmix(n = 2000, unknownComp_weight = 0.7, comp.dist = list(f = 'norm', g = 'norm'),
                 comp.param = list(f = list(mean = 3, sd = 0.5), g = list(mean = 0, sd = 1)))
class(sim.X)
attributes(sim.X)
plot_admix(sim.X = sim.X$mixt.data, sim.Y = NULL, user.bounds = NULL, support = 'continuous')

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
