% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_shift.R
\name{derive_var_shift}
\alias{derive_var_shift}
\title{Derive Shift}
\usage{
derive_var_shift(
  dataset,
  new_var,
  from_var,
  to_var,
  na_val,
  missing_value = "NULL",
  sep_val = " to "
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{from_var} and \code{to_var} arguments are expected to be in the dataset.}

\item{new_var}{Name of the character shift variable to create.}

\item{from_var}{Variable containing value to shift from.}

\item{to_var}{Variable containing value to shift to.}

\item{na_val}{\emph{Deprecated}, please use \code{missing_value} instead.}

\item{missing_value}{Character string to replace missing values in \code{from_var} or \code{to_var}.

Default: "NULL"}

\item{sep_val}{Character string to concatenate values of \code{from_var} and \code{to_var}.

Default: " to "}
}
\value{
The input dataset with the character shift variable added
}
\description{
Derives a character shift variable containing concatenated shift in
values based on user-defined pairing, e.g., shift from baseline to
analysis value, shift from baseline grade to analysis grade, ...
}
\details{
\code{new_var} is derived by concatenating the values of \code{from_var} to values of \code{to_var}
(e.g. "NORMAL to HIGH"). When \code{from_var} or \code{to_var} has missing value, the
missing value is replaced by \code{missing_value} (e.g. "NORMAL to NULL").
}
\examples{
library(tibble)

data <- tribble(
  ~USUBJID, ~PARAMCD, ~AVAL, ~ABLFL, ~BNRIND, ~ANRIND,
  "P01", "ALB", 33, "Y", "LOW", "LOW",
  "P01", "ALB", 38, NA, "LOW", "NORMAL",
  "P01", "ALB", NA, NA, "LOW", NA,
  "P02", "ALB", 37, "Y", "NORMAL", "NORMAL",
  "P02", "ALB", 49, NA, "NORMAL", "HIGH",
  "P02", "SODIUM", 147, "Y", "HIGH", "HIGH"
)

data \%>\%
  convert_blanks_to_na() \%>\%
  derive_var_shift(
    new_var = SHIFT1,
    from_var = BNRIND,
    to_var = ANRIND
  )

# or only populate post-baseline records
data \%>\%
  convert_blanks_to_na() \%>\%
  restrict_derivation(
    derivation = derive_var_shift,
    args = params(
      new_var = SHIFT1,
      from_var = BNRIND,
      to_var = ANRIND
    ),
    filter = is.na(ABLFL)
  )
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_basetype_records}()},
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
