% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{atoxgr_criteria_daids}
\alias{atoxgr_criteria_daids}
\title{Metadata Holding Grading Criteria for DAIDs}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 63 rows and 15 columns.
}
\usage{
atoxgr_criteria_daids
}
\description{
Metadata Holding Grading Criteria for DAIDs
}
\details{
This metadata has its origin in the ADLB Grading Spec Excel file which ships with \code{{admiral}}
and can be accessed using \code{system.file("adlb_grading/adlb_grading_spec.xlsx", package = "admiral")}
in sheet = "DAIDS".
The dataset contained in there has the following columns:
\itemize{
\item \code{SOC}: variable to hold the SOC of the lab test criteria.
\item \code{TERM}: variable to hold the term describing the criteria applied to a particular lab test,
eg. 'Anemia' or 'INR Increased'. Note: the variable is case insensitive.
\item \code{SUBGROUP} : Description of sub-group of subjects were grading will be applied (i.e. >= 18 years)
\item \verb{Grade 1}: Criteria defining lab value as Grade 1.
\item \verb{Grade 2}: Criteria defining lab value as Grade 2.
\item \verb{Grade 3}: Criteria defining lab value as Grade 3.
\item \verb{Grade 4}: Criteria defining lab value as Grade 4.
\item \verb{Grade 5}: Criteria defining lab value as Grade 5.
\item \code{Definition}: Holds the definition of the lab test abnormality.
\item \code{FILTER} : \code{admiral} code to apply the filter based on SUBGROUP column.
\item \code{GRADE_CRITERIA_CODE}: variable to hold code that creates grade based on defined criteria.
\item \code{SI_UNIT_CHECK}: variable to hold unit of particular lab test. Used to check against input data
if criteria is based on absolute values.
\item \code{VAR_CHECK}: List of variables required to implement lab grade criteria. Use to check against
input data.
\item \code{DIRECTION}: variable to hold the direction of the abnormality of a particular lab test
value. 'L' is for LOW values, 'H' is for HIGH values. Note: the variable is case insensitive.
\item \code{COMMENT}: Holds any information regarding rationale behind implementation of grading criteria.
}

Note: Variables \code{SOC}, \code{TERM}, \code{SUBGROUP}, \verb{Grade 1}, \verb{Grade 2},\verb{Grade 3},\verb{Grade 4},\verb{Grade 5}, \code{Definition}
are from the source document on DAIDS website defining the grading criteria.
[Division of AIDS (DAIDS) Table for Grading the Severity of Adult and Pediatric Adverse Events
From these variables only 'TERM' is used in the \code{{admiral}} code, the rest are for information and
traceability only.
}
\seealso{
Other metadata: 
\code{\link{atoxgr_criteria_ctcv4}},
\code{\link{atoxgr_criteria_ctcv5}},
\code{\link{dose_freq_lookup}}
}
\concept{metadata}
\keyword{metadata}
