% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_advs_params.R
\name{compute_bsa}
\alias{compute_bsa}
\title{Compute Body Surface Area (BSA)}
\usage{
compute_bsa(height = height, weight = weight, method)
}
\arguments{
\item{height}{HEIGHT value

It is expected that HEIGHT is in cm.

Permitted Values: numeric vector}

\item{weight}{WEIGHT value

It is expected that WEIGHT is in kg.

Permitted Values: numeric vector}

\item{method}{Derivation method to use:

Mosteller: sqrt(height * weight / 3600)

DuBois-DuBois: 0.20247 * (height/100) ^ 0.725 * weight ^ 0.425

Haycock: 0.024265 * height ^ 0.3964 * weight ^ 0.5378

Gehan-George: 0.0235 * height ^ 0.42246 * weight ^ 0.51456

Boyd: 0.0003207 * (height ^ 0.3) * (1000 * weight) ^ (0.7285 - (0.0188 * log10(1000 * weight)))

Fujimoto: 0.008883 * height ^ 0.663 * weight ^ 0.444

Takahira: 0.007241 * height ^ 0.725 * weight ^ 0.425

Permitted Values: character value}
}
\value{
The BSA (Body Surface Area) in m^2.
}
\description{
Computes BSA from height and weight making use of the specified derivation method
}
\details{
Usually this computation function can not be used with \verb{\%>\%}.
}
\examples{
# Derive BSA by the Mosteller method
compute_bsa(
  height = 170,
  weight = 75,
  method = "Mosteller"
)

# Derive BSA by the DuBois & DuBois method
compute_bsa(
  height = c(170, 185),
  weight = c(75, 90),
  method = "DuBois-DuBois"
)
}
\seealso{
BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_framingham}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_rr}()}
}
\author{
Eric Simms
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
