% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{write.adf}
\alias{write.adf}
\alias{write.adf,amigaDisk,ANY-method}
\alias{write.adf,amigaDisk,character-method}
\alias{write.adz}
\alias{write.adz,amigaDisk,character-method}
\title{Write an amigaDisk object to an ADF file}
\usage{
\S4method{write.adf}{amigaDisk,ANY}(x, file)

\S4method{write.adf}{amigaDisk,character}(x, file)

\S4method{write.adz}{amigaDisk,character}(x, file)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object that needs to be saved to
an ADF file.}

\item{file}{either a file name to write to, or a file connection, that
allows to write binary data (see \code{\link[base:connections]{file}}).
\code{write.adz} only accepts a file name.}
}
\value{
Writes to an ADF file but returns nothing.
}
\description{
Write an \code{\link{amigaDisk}} object to an Amiga Disk File (ADF) or
alternatively to an ADZ file.
}
\details{
Use this function to write \code{\link{amigaDisk}} objects as binary
data to so-called Amiga Disk Files (ADF). These files can be used as
input for Amiga emulator software.

Alternatively, the object can be saved with 'write.adz', which is
essentially a gzipped version of an ADF file.
}
\examples{
\dontrun{
## Let's write the example data to an ADF file:
data(adf.example)

## Let's put it in the current working directory:
write.adf(adf.example, "test.adf")

## You can also use file connections to do the same:
con <- file("test2.adf", "wb")
write.adf(adf.example, con)
close(con)

## Last but not least the same object can be saved
## as an adz file:
write.adz(adf.example, "test.3.adz")
}
}
\seealso{
Other io.operations: 
\code{\link{read.adf}()}
}
\author{
Pepijn de Vries
}
\concept{io.operations}
