% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\docType{methods}
\name{get.blockID}
\alias{get.blockID}
\alias{get.blockID,character,numeric,numeric,numeric-method}
\title{Get the block ID from the physical location on the disk}
\usage{
\S4method{get.blockID}{character,numeric,numeric,numeric}(disktype, sector, side, cylinder)
}
\arguments{
\item{disktype}{A \code{character} string indicating the type of disk:
\code{DD} for double density disks. \code{HD} for high density disks.}

\item{sector}{\code{numeric} identifier for the sector on the disk, ranging
from 0 up to 10 (\code{DD} disks) or 21 (\code{HD} disks).}

\item{side}{\code{numeric} identifier for the side of the disk (0 or 1).}

\item{cylinder}{\code{numeric} identifier for the cylinder on the disk,
ranging from 0 up to 79.}
}
\value{
Returns the \code{numeric} identifier for the corresponding block.
}
\description{
Get the block identifier based on the physical location on a disk (side,
cylinder and sector) and the disk type.
}
\details{
Data on Amiga floppy disks are stored as 512 byte blocks. These blocks
are physically stored on a specific cylinder and side at a specific sector.
This method returns the block identifier based on the physical location
on the disk. The inverse of this function is achieved with the
\code{\link{get.diskLocation}} method.

Note that all identifiers (or indices) have a base at zero, for consistency
with Amiga specifications and documentation, opposed to the base of one
used in R.
}
\examples{
## Get the block identifier for sectors 0 up to 3 combined with
## cylinders 0 up to 3 on side 0 of the disk:
get.blockID(disktype = "DD",
            sector   = 0:3,
            side     = 0,
            cylinder = 0:3)
}
\seealso{
Other block.operations: 
\code{\link{amigaBlock-method}},
\code{\link{get.diskLocation}()}
}
\author{
Pepijn de Vries
}
\concept{block.operations}
