% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{read.adf}
\alias{read.adf}
\alias{read.adf,character-method}
\alias{read.adf,ANY-method}
\alias{read.adz}
\alias{read.adz,character-method}
\title{Read an Amiga Disk File}
\usage{
\S4method{read.adf}{character}(file)

\S4method{read.adf}{ANY}(file)

\S4method{read.adz}{character}(file)
}
\arguments{
\item{file}{Either a file name or a file connection, that
allows reading binary data (see e.g., \code{\link[base]{file}} or
\code{\link[base]{url}}). \code{read.adz} only accepts file names.}
}
\value{
Returns an \code{\link{amigaDisk}} object read from the provided amiga disk file
}
\description{
Read data from an Amiga Disk File (ADF) to an \code{\link{amigaDisk}}
object. Alternatively data can be read from an ADZ file.
}
\details{
Amiga Disk Files usually have a .adf-extension to the file name.
It should be 880 kB (double density) or 1760 kB (high density)
in size. This function can read such files.

Alternatively, ADZ files can also be read. These are essentially
gzipped ADF files.

Note that this package cannot read extended ADF files containing
information on the disk's Modified frequency modulation (MFM).
This information is typically only required for copy protected disk's
and is therefore out of the scope of this package.
}
\examples{
\dontrun{
## In order to read an adf-file, we first need one.
## so let's first write the example obect to a file:
data(adf.example)

## write it to the current working directory:
write.adf(adf.example, "test.adf")

## now we can read it again:
my.disk <- read.adf("test.adf")
print(my.disk)

## and this is how you read it,
## using a connection:
con <- file("test.adf", "rb")
my.disk2 <- read.adf(con)
close(con)

print(my.disk2)

## Alternatively, you can work with ADZ files:
write.adz(adf.example, "test.adz")
my.disk3 <- read.adz("test.adz")

print(my.disk3)
}
}
\seealso{
Other io.operations: \code{\link{write.adf}}
}
\author{
Pepijn de Vries
}
