% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_parametric.R
\name{adea_parametric}
\alias{adea_parametric}
\title{Selection of an optimal subset of variables for DEA analysis}
\usage{
adea_parametric(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  name = "",
  direction = c("backward", "backward/input", "backward/output"),
  solver = "auto",
  verbose = 0
)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{load.orientation}{This parameter allows the selection of variables to be included in load analysis. 
The default is "inoutput" which means that all input and output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{name}{An optional descriptive name for the model.
The default is an empty string. 
This name will be displayed in printed and summarized results.}

\item{direction}{The direction in which the variables enter or exit the model.
Currently, only the "backward" option is implemented.}

\item{solver}{The solver used by ROI to solve the DEA optimization problem.
The default is "auto."
The solver must be installed and capable of solving linear programming problems. 
Use \code{ROI_installed_solvers()} to list them.}

\item{verbose}{Use 0 for minimal output, displaying only the final model.
Use 1 or higher values to get detailed information for each step.
The default is 0.
This option affects only the printed output and not the result.}
}
\value{
The function returns an adeaparametric class object with the following named members:
\itemize{
\item name: A label of the model.
\item orientation: DEA model orientation ('input' or 'output').
\item load.orientation: load DEA model orientation ('input', 'output', or 'inoutput').
\item loads: Load of each model.
\item models: List of all ADEA models.
\item ninputs: Number of input variables in each model.
\item noutputs: Number of output variables in each model.
\item nvariables: Number of variables in each model.
\item inputnames: Names of input variables in each model.
\item outputnames: Names of output variables in each model.
\item out: Variable, or variables, dropped in each step.
\item solver: The solver used for the resolution of the optimization problem.
}
}
\description{
The function returns a list of DEA models, progressively removing at least one variable at each step.
This process results in a sequence of models with increasing values ADEA loads.
}
\details{
The models are sorted by increasing values of loads, starting from initially given model and progressing to the one with one input and one output variable.
Note that the load value for the model with one input and one output is 1.
In each step, at least one variable is dropped, but more than one can be dropped if necessary.

See example for more details.
}
\examples{
# Read data
data('cardealers4')
input <- cardealers4[, c('Employees', 'Depreciation')]
output <- cardealers4[, c('CarsSold', 'WorkOrders')]

# Compute all dea models in parametric way and store in sol.ap
sol.ap <- adea_parametric(input, output)
# Show result
sol.ap
#       Loads nEfficients nVariables nInputs nOutputs                  Inputs              Outputs
# 4 0.6666667           2          4       2        2 Employees, Depreciation CarsSold, WorkOrders
# 3 0.9575672           2          3       1        2            Depreciation CarsSold, WorkOrders
# 2 1.0000000           1          2       1        1            Depreciation             CarsSold

# Summary the model with 3 variables
summary(sol.ap$models[[3]])
# Model name                                 
# Orientation                           input
# Load orientation                   inoutput
# Model load                0.957567163474156
# Input load.Depreciation                   1
# Output load.CarsSold       1.04243283652584
# Output load.WorkOrders    0.957567163474156
# Inputs                         Depreciation
# Outputs                 CarsSold WorkOrders
# nInputs                                   1
# nOutputs                                  2
# nVariables                                3
# nEfficients                               2
# Eff. Mean                  0.90022318389575
# Eff. sd                   0.135194867030839
# Eff. Min.                 0.651504424778761
# Eff. 1st Qu.              0.872252747252747
# Eff. Median               0.942225031605563
# Eff. 3rd Qu.              0.997898230088496
# Eff. Max.                                 1
# Get efficiencies for the model with 3 variables
sol.ap$models[[3]]$eff
#  Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044
}
\seealso{
\code{\link{adea_hierarchical}}
}
