library("adea")
library("testthat")

test_that("cardealers demo", {
    demo("cardealers")
    expect_s3_class(sol.adea, "adea")
    expect_equal(sol.adea$loads$load, 0.66666667)
    expect_equal(sol.adea$loads$iinput, c("Employees" = 1))
    expect_s3_class(sol.ah, "adeahierarchical")
    expect_length(sol.ah$models, 4)
    expect_equal(sol.ah$models[[4]]$loads$load, 0.66666667)
    expect_equal(sol.ah$models[[4]]$loads$iinput, c("Employees" = 1))
    expect_s3_class(sol.ap, "adeaparametric")
    expect_length(sol.ap$models, 4)
    expect_equal(sol.ap$models[[4]]$loads$load, 0.66666667)
    expect_equal(sol.ap$models[[4]]$loads$iinput, c("Employees" = 1))
})

test_that("spanishuniversities2018 demo", {
    skip_on_cran()
    demo("spanishuniversities2018")
    expect_s3_class(sol.dea, "dea")
    expect_equal(as.numeric(sol.dea$eff[1]), 0.77542788)
    expect_equal(sol.dea$ux[1], 0.00091240876)
    expect_s3_class(sol.adea, "adea")
    expect_equal(sol.adea$loads$load, 0.58985841)
    expect_equal(as.numeric(sol.adea$loads$output[7]), 0.75717137)
})

test_that("cardealers demo", {
    skip_on_cran()
    demo("tokyo_libraries")
    expect_s3_class(sol.adea, "adea")
    expect_equal(sol.adea$loads$load, 0.455467)
    expect_equal(names(sol.adea$loads$iinput), c("Area.I1"))
    expect_s3_class(sol.adea, "adea")
    expect_equal(sol.adea$loads$load, 0.455467)
    expect_equal(names(sol.adea$loads$iinput), c("Area.I1"))
})
