// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#define R_NO_REMAP
#include <R.h>
#include <Rinternals.h>

/* generated by tools/make-callentries.R */
SEXP RAdbcVoidDriverInitFunc(void);
SEXP RAdbcMonkeyDriverInitFunc(void);
SEXP RAdbcLogDriverInitFunc(void);
SEXP RAdbcAllocateError(SEXP shelter_sexp, SEXP use_legacy_error_sexp);
SEXP RAdbcErrorProxy(SEXP error_xptr);
SEXP RAdbcErrorFromArrayStream(SEXP stream_xptr);
SEXP RAdbcStatusCodeMessage(SEXP status_sexp);
SEXP RAdbcDatabaseSetOption(SEXP database_xptr, SEXP key_sexp, SEXP value_sexp,
                            SEXP error_xptr);
SEXP RAdbcConnectionSetOption(SEXP connection_xptr, SEXP key_sexp, SEXP value_sexp,
                              SEXP error_xptr);
SEXP RAdbcStatementSetOption(SEXP statement_xptr, SEXP key_sexp, SEXP value_sexp,
                             SEXP error_xptr);
SEXP RAdbcDatabaseGetOption(SEXP database_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcDatabaseGetOptionBytes(SEXP database_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcDatabaseGetOptionInt(SEXP database_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcDatabaseGetOptionDouble(SEXP database_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcConnectionGetOption(SEXP connection_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcConnectionGetOptionBytes(SEXP connection_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcConnectionGetOptionInt(SEXP connection_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcConnectionGetOptionDouble(SEXP connection_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcStatementGetOption(SEXP statement_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcStatementGetOptionBytes(SEXP statement_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcStatementGetOptionInt(SEXP statement_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcStatementGetOptionDouble(SEXP statement_xptr, SEXP key_sexp, SEXP error_xptr);
SEXP RAdbcCurrentArch(void);
SEXP RAdbcAllocateDriver(void);
SEXP RAdbcLoadDriver(SEXP driver_name_sexp, SEXP entrypoint_sexp, SEXP version_sexp,
                     SEXP load_flags_sexp, SEXP driver_sexp, SEXP error_sexp);
SEXP RAdbcLoadDriverFromInitFunc(SEXP driver_init_func_xptr, SEXP version_sexp,
                                 SEXP driver_sexp, SEXP error_sexp);
SEXP RAdbcDatabaseNew(SEXP driver_init_func_xptr, SEXP load_flags_sexp);
SEXP RAdbcMoveDatabase(SEXP database_xptr);
SEXP RAdbcDatabaseValid(SEXP database_xptr);
SEXP RAdbcDatabaseInit(SEXP database_xptr, SEXP error_xptr);
SEXP RAdbcDatabaseRelease(SEXP database_xptr, SEXP error_xptr);
SEXP RAdbcConnectionNew(void);
SEXP RAdbcMoveConnection(SEXP connection_xptr);
SEXP RAdbcConnectionValid(SEXP connection_xptr);
SEXP RAdbcConnectionInit(SEXP connection_xptr, SEXP database_xptr, SEXP error_xptr);
SEXP RAdbcConnectionRelease(SEXP connection_xptr, SEXP error_xptr);
SEXP RAdbcConnectionGetInfo(SEXP connection_xptr, SEXP info_codes_sexp,
                            SEXP out_stream_xptr, SEXP error_xptr);
SEXP RAdbcConnectionGetObjects(SEXP connection_xptr, SEXP depth_sexp, SEXP catalog_sexp,
                               SEXP db_schema_sexp, SEXP table_name_sexp,
                               SEXP table_type_sexp, SEXP column_name_sexp,
                               SEXP out_stream_xptr, SEXP error_xptr);
SEXP RAdbcConnectionGetTableSchema(SEXP connection_xptr, SEXP catalog_sexp,
                                   SEXP db_schema_sexp, SEXP table_name_sexp,
                                   SEXP schema_xptr, SEXP error_xptr);
SEXP RAdbcConnectionGetTableTypes(SEXP connection_xptr, SEXP out_stream_xptr,
                                  SEXP error_xptr);
SEXP RAdbcConnectionReadPartition(SEXP connection_xptr, SEXP serialized_partition_sexp,
                                  SEXP out_stream_xptr, SEXP error_xptr);
SEXP RAdbcConnectionCommit(SEXP connection_xptr, SEXP error_xptr);
SEXP RAdbcConnectionRollback(SEXP connection_xptr, SEXP error_xptr);
SEXP RAdbcConnectionCancel(SEXP connection_xptr, SEXP error_xptr);
SEXP RAdbcConnectionGetStatisticNames(SEXP connection_xptr, SEXP out_stream_xptr,
                                      SEXP error_xptr);
SEXP RAdbcConnectionGetStatistics(SEXP connection_xptr, SEXP catalog_sexp,
                                  SEXP db_schema_sexp, SEXP table_name_sexp,
                                  SEXP approximate_sexp, SEXP out_stream_xptr,
                                  SEXP error_xptr);
SEXP RAdbcStatementNew(SEXP connection_xptr);
SEXP RAdbcMoveStatement(SEXP statement_xptr);
SEXP RAdbcStatementValid(SEXP statement_xptr);
SEXP RAdbcStatementRelease(SEXP statement_xptr, SEXP error_xptr);
SEXP RAdbcStatementSetSqlQuery(SEXP statement_xptr, SEXP query_sexp, SEXP error_xptr);
SEXP RAdbcStatementSetSubstraitPlan(SEXP statement_xptr, SEXP plan_sexp, SEXP error_xptr);
SEXP RAdbcStatementPrepare(SEXP statement_xptr, SEXP error_xptr);
SEXP RAdbcStatementGetParameterSchema(SEXP statement_xptr, SEXP out_schema_xptr,
                                      SEXP error_xptr);
SEXP RAdbcStatementBind(SEXP statement_xptr, SEXP values_xptr, SEXP schema_xptr,
                        SEXP error_xptr);
SEXP RAdbcStatementBindStream(SEXP statement_xptr, SEXP stream_xptr, SEXP error_xptr);
SEXP RAdbcStatementExecuteQuery(SEXP statement_xptr, SEXP out_stream_xptr,
                                SEXP error_xptr);
SEXP RAdbcStatementExecuteSchema(SEXP statement_xptr, SEXP out_schema_xptr,
                                 SEXP error_xptr);
SEXP RAdbcStatementExecutePartitions(SEXP statement_xptr, SEXP out_schema_xptr,
                                     SEXP partitions_xptr, SEXP error_xptr);
SEXP RAdbcStatementCancel(SEXP statement_xptr, SEXP error_xptr);
SEXP RAdbcXptrEnv(SEXP xptr);
SEXP RAdbcXptrSetProtected(SEXP xptr, SEXP prot);

static const R_CallMethodDef CallEntries[] = {
    {"RAdbcVoidDriverInitFunc", (DL_FUNC)&RAdbcVoidDriverInitFunc, 0},
    {"RAdbcMonkeyDriverInitFunc", (DL_FUNC)&RAdbcMonkeyDriverInitFunc, 0},
    {"RAdbcLogDriverInitFunc", (DL_FUNC)&RAdbcLogDriverInitFunc, 0},
    {"RAdbcAllocateError", (DL_FUNC)&RAdbcAllocateError, 2},
    {"RAdbcErrorProxy", (DL_FUNC)&RAdbcErrorProxy, 1},
    {"RAdbcErrorFromArrayStream", (DL_FUNC)&RAdbcErrorFromArrayStream, 1},
    {"RAdbcStatusCodeMessage", (DL_FUNC)&RAdbcStatusCodeMessage, 1},
    {"RAdbcDatabaseSetOption", (DL_FUNC)&RAdbcDatabaseSetOption, 4},
    {"RAdbcConnectionSetOption", (DL_FUNC)&RAdbcConnectionSetOption, 4},
    {"RAdbcStatementSetOption", (DL_FUNC)&RAdbcStatementSetOption, 4},
    {"RAdbcDatabaseGetOption", (DL_FUNC)&RAdbcDatabaseGetOption, 3},
    {"RAdbcDatabaseGetOptionBytes", (DL_FUNC)&RAdbcDatabaseGetOptionBytes, 3},
    {"RAdbcDatabaseGetOptionInt", (DL_FUNC)&RAdbcDatabaseGetOptionInt, 3},
    {"RAdbcDatabaseGetOptionDouble", (DL_FUNC)&RAdbcDatabaseGetOptionDouble, 3},
    {"RAdbcConnectionGetOption", (DL_FUNC)&RAdbcConnectionGetOption, 3},
    {"RAdbcConnectionGetOptionBytes", (DL_FUNC)&RAdbcConnectionGetOptionBytes, 3},
    {"RAdbcConnectionGetOptionInt", (DL_FUNC)&RAdbcConnectionGetOptionInt, 3},
    {"RAdbcConnectionGetOptionDouble", (DL_FUNC)&RAdbcConnectionGetOptionDouble, 3},
    {"RAdbcStatementGetOption", (DL_FUNC)&RAdbcStatementGetOption, 3},
    {"RAdbcStatementGetOptionBytes", (DL_FUNC)&RAdbcStatementGetOptionBytes, 3},
    {"RAdbcStatementGetOptionInt", (DL_FUNC)&RAdbcStatementGetOptionInt, 3},
    {"RAdbcStatementGetOptionDouble", (DL_FUNC)&RAdbcStatementGetOptionDouble, 3},
    {"RAdbcCurrentArch", (DL_FUNC)&RAdbcCurrentArch, 0},
    {"RAdbcAllocateDriver", (DL_FUNC)&RAdbcAllocateDriver, 0},
    {"RAdbcLoadDriver", (DL_FUNC)&RAdbcLoadDriver, 6},
    {"RAdbcLoadDriverFromInitFunc", (DL_FUNC)&RAdbcLoadDriverFromInitFunc, 4},
    {"RAdbcDatabaseNew", (DL_FUNC)&RAdbcDatabaseNew, 2},
    {"RAdbcMoveDatabase", (DL_FUNC)&RAdbcMoveDatabase, 1},
    {"RAdbcDatabaseValid", (DL_FUNC)&RAdbcDatabaseValid, 1},
    {"RAdbcDatabaseInit", (DL_FUNC)&RAdbcDatabaseInit, 2},
    {"RAdbcDatabaseRelease", (DL_FUNC)&RAdbcDatabaseRelease, 2},
    {"RAdbcConnectionNew", (DL_FUNC)&RAdbcConnectionNew, 0},
    {"RAdbcMoveConnection", (DL_FUNC)&RAdbcMoveConnection, 1},
    {"RAdbcConnectionValid", (DL_FUNC)&RAdbcConnectionValid, 1},
    {"RAdbcConnectionInit", (DL_FUNC)&RAdbcConnectionInit, 3},
    {"RAdbcConnectionRelease", (DL_FUNC)&RAdbcConnectionRelease, 2},
    {"RAdbcConnectionGetInfo", (DL_FUNC)&RAdbcConnectionGetInfo, 4},
    {"RAdbcConnectionGetObjects", (DL_FUNC)&RAdbcConnectionGetObjects, 9},
    {"RAdbcConnectionGetTableSchema", (DL_FUNC)&RAdbcConnectionGetTableSchema, 6},
    {"RAdbcConnectionGetTableTypes", (DL_FUNC)&RAdbcConnectionGetTableTypes, 3},
    {"RAdbcConnectionReadPartition", (DL_FUNC)&RAdbcConnectionReadPartition, 4},
    {"RAdbcConnectionCommit", (DL_FUNC)&RAdbcConnectionCommit, 2},
    {"RAdbcConnectionRollback", (DL_FUNC)&RAdbcConnectionRollback, 2},
    {"RAdbcConnectionCancel", (DL_FUNC)&RAdbcConnectionCancel, 2},
    {"RAdbcConnectionGetStatisticNames", (DL_FUNC)&RAdbcConnectionGetStatisticNames, 3},
    {"RAdbcConnectionGetStatistics", (DL_FUNC)&RAdbcConnectionGetStatistics, 7},
    {"RAdbcStatementNew", (DL_FUNC)&RAdbcStatementNew, 1},
    {"RAdbcMoveStatement", (DL_FUNC)&RAdbcMoveStatement, 1},
    {"RAdbcStatementValid", (DL_FUNC)&RAdbcStatementValid, 1},
    {"RAdbcStatementRelease", (DL_FUNC)&RAdbcStatementRelease, 2},
    {"RAdbcStatementSetSqlQuery", (DL_FUNC)&RAdbcStatementSetSqlQuery, 3},
    {"RAdbcStatementSetSubstraitPlan", (DL_FUNC)&RAdbcStatementSetSubstraitPlan, 3},
    {"RAdbcStatementPrepare", (DL_FUNC)&RAdbcStatementPrepare, 2},
    {"RAdbcStatementGetParameterSchema", (DL_FUNC)&RAdbcStatementGetParameterSchema, 3},
    {"RAdbcStatementBind", (DL_FUNC)&RAdbcStatementBind, 4},
    {"RAdbcStatementBindStream", (DL_FUNC)&RAdbcStatementBindStream, 3},
    {"RAdbcStatementExecuteQuery", (DL_FUNC)&RAdbcStatementExecuteQuery, 3},
    {"RAdbcStatementExecuteSchema", (DL_FUNC)&RAdbcStatementExecuteSchema, 3},
    {"RAdbcStatementExecutePartitions", (DL_FUNC)&RAdbcStatementExecutePartitions, 4},
    {"RAdbcStatementCancel", (DL_FUNC)&RAdbcStatementCancel, 2},
    {"RAdbcXptrEnv", (DL_FUNC)&RAdbcXptrEnv, 1},
    {"RAdbcXptrSetProtected", (DL_FUNC)&RAdbcXptrSetProtected, 2},
    {NULL, NULL, 0}};
/* end generated by tools/make-callentries.R */

void R_init_adbcdrivermanager(DllInfo* dll) {
  R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
  R_useDynamicSymbols(dll, FALSE);
}
