% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_history.R
\name{extract_history}
\alias{extract_history}
\title{Extract history}
\usage{
extract_history(object, metric = "prob")
}
\arguments{
\item{object}{single \code{trial_result} from \code{\link[=run_trial]{run_trial()}}, only works if run
with argument \code{sparse = FALSE}.}

\item{metric}{either \code{"prob"} (default), in which case allocation
probabilities at each adaptive analysis are returned; \code{"n"}/\code{"n all"}, in
which case the total number of patients with available follow-up data
(\code{"n"}) or allocated (\code{"n all"}) to each \code{arm} during each adaptive
analysis are returned; \code{"pct"}/\code{"pct all"} in which case the proportions of
of patients allocated and having available follow-up data (\code{"pct"}) or
allocated in total (\code{"pct all"}) to each arm out of the total number of
patients are returned; \code{"sum ys"}/\code{"sum ys all"}, in which case the total
summed available outcome data (\code{"sum ys"}) or total summed outcome data
including outcomes of patients randomised that have not necessarily reached
follow-up yet (\code{"sum ys all"}) in each arm after each adaptive analysis are
returned; or \code{"ratio ys"}/\code{"ratio ys all"}, in which case the total summed
outcomes as specified for \code{"sum ys"}/\code{"sum ys all"} divided by the number
of patients after each analysis adaptive are returned.}
}
\value{
A tidy \code{data.frame} (one row per arm per look) containing the following
columns:
\itemize{
\item \code{look}: consecutive numbers (integers) of each interim look.
\item \code{look_ns}: total number of patients (integers) with outcome data
available at current adaptive analysis look to all arms in the trial.
\item \code{look_ns_all}: total number of patients (integers) randomised at
current adaptive analysis look to all arms in the trial.
\item \code{arm}: the current \code{arm} in the trial.
\item \code{value}: as described under \code{metric}.
}
}
\description{
Used internally. Extracts relevant parameters at each conducted adaptive
analysis from a single trial.
}
\keyword{internal}
