% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.R
\name{ReadTrack}
\alias{ReadTrack}
\title{Tracks files that read by functions not in adapr and captures the file information within dependency object}
\usage{
ReadTrack(file.name = "data.csv", description = "Data file")
}
\arguments{
\item{file.name}{name of file (vectorized)}

\item{description}{description of data file (vectorized)}
}
\value{
Filepath of file to read
}
\description{
Tracks files that read by functions not in adapr and captures the file information within dependency object
}
\details{
Allows tracking of files read by other functions than Read. Assumes file is in project "Data" directory
}
\examples{
\dontrun{
 source_info <- create_source_file_dir("adaprHome","tree_controller.R")
write.csv(cars,file.path(source_info$data.dir,"test.csv"))
# Read with any function
temp <- utils::read.csv(file.path(source_info$data.dir,"test.csv"))
ReadTrack("test.csv","cars dataframe")
# Will track the file as though read with Read().
file.remove(file.path(source_info$data.dir,"test.csv"))
} 
}

