% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.R
\name{Read}
\alias{Read}
\title{Read data and capture the file information within dependency object}
\usage{
Read(file.name = "data.csv", description = "Data file",
  read.fcn = guess.read.fcn(file.name), ...)
}
\arguments{
\item{file.name}{name of file}

\item{description}{description of data file}

\item{read.fcn}{function for reading file}

\item{...}{arguments to read function}
}
\value{
object read from file
}
\description{
Read data and capture the file information within dependency object
}
\details{
Simpler command than Read.cap, automatically generates file info. Assumes file is in project "Data" directory
}
\examples{
\dontrun{
source_info <- create_source_file_dir("adaprHome","tree_controller.R")
write.csv(cars,file.path(source_info$data.dir,"test.csv"))
Read("test.csv","cars dataframe")
file.remove(file.path(source_info$data.dir,"test.csv"))
}  
}

