% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archetypoids_funct_multiv_robust.R
\name{archetypoids_funct_multiv_robust}
\alias{archetypoids_funct_multiv_robust}
\title{Archetypoid algorithm with the functional multivariate robust Frobenius norm}
\usage{
archetypoids_funct_multiv_robust(numArchoid, data, huge = 200, ArchObj, PM, prob)
}
\arguments{
\item{numArchoid}{Number of archetypoids.}

\item{data}{Data matrix. Each row corresponds to an observation and each column 
corresponds to a variable. All variables are numeric.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{ArchObj}{The list object returned by the 
\code{\link{stepArchetypesRawData_funct}} function.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{prob}{Probability with values in [0,1].}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item archet_ini: Vector of initial archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item resid: Matrix with the residuals.
}
}
\description{
Archetypoid algorithm with the functional multivariate robust Frobenius norm 
to be used with functional data.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- growth$hgtm
hgtf <- growth$hgtf[,1:39]

# Create array:
nvars <- 2
data.array <- array(0, dim = c(dim(hgtm), nvars))
data.array[,,1] <- as.matrix(hgtm)
data.array[,,2] <- as.matrix(hgtf)
rownames(data.array) <- 1:nrow(hgtm)
colnames(data.array) <- colnames(hgtm)
str(data.array)

# Create basis:
nbasis <- 10
basis_fd <- create.bspline.basis(c(1,nrow(hgtm)), nbasis)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:nrow(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = data.array, basisobj = basis_fd)

X <- array(0, dim = c(dim(t(temp_fd$coefs[,,1])), nvars))
X[,,1] <- t(temp_fd$coef[,,1]) 
X[,,2] <- t(temp_fd$coef[,,2])

# Standardize the variables:
Xs <- X
Xs[,,1] <- scale(X[,,1])
Xs[,,2] <- scale(X[,,2])

lass <- stepArchetypesRawData_funct_multiv_robust(data = Xs, numArch = 3, 
                                                  numRep = 5, verbose = FALSE, 
                                                  saveHistory = FALSE, PM, prob = 0.8, 
                                                  nbasis, nvars)

afmr <- archetypoids_funct_multiv_robust(3, Xs, huge = 200, ArchObj = lass, PM, 0.8)
str(afmr)
}                                                          
                                                     
}
\seealso{
\code{\link[Anthropometry]{archetypoids}}
}
\author{
Guillermo Vinue
}
