% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fig_mx_summary.R
\name{create_fig_mx_summary}
\alias{create_fig_mx_summary}
\title{Create a radar plot for the mean or median MX metrics relating to the measurement of physical behavior}
\usage{
create_fig_mx_summary(
  data,
  labels = NULL,
  mpa_cutpoint = 2690,
  vpa_cutpoint = 6167
)
}
\arguments{
\item{data}{A dataframe with physical behavior metrics summarised using means or medians of valid days. It should have
been obtained using the \code{\link{prepare_dataset}}, \code{\link{mark_wear_time}}, \code{\link{mark_intensity}},
\code{\link{recap_by_day}}, and then the \code{\link{average_results}} functions.}

\item{labels}{A vector of numeric values setting the breaks of the Y axis of the radar plot. Default is a vector of 6 values with
a start at 0 and an end at the maximum of all the computed MX metrics.}

\item{mpa_cutpoint}{A numeric value at and above which time is considered as spent in moderate-to-vigorous physical activity (in counts/epoch length used to compute MX metrics).
Defaut value is from Sasaki et al. (2011; doi:10.1016/j.jsams.2011.04.003) relating to vector magnitude.}

\item{vpa_cutpoint}{A numeric value at and above which time is considered as spent in vigorous physical activity (in counts/epoch length used to compute MX metrics).
Defaut value is from Sasaki et al. (2011; doi:10.1016/j.jsams.2011.04.003) relating to vector magnitude.}
}
\value{
A ggplot object
}
\description{
This function creates a radar plot in relation to MX metrics as illustrated in Rowlands et al.
(2018; doi:10.1249/MSS.0000000000001561) paper.
}
\examples{
\donttest{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male"
    )
summary_by_day <- recap_by_day(
    data = mydata_with_intensity_marks, 
    col_axis = "vm",
    age = 32, 
    weight = 67, 
    sex = "male",
    valid_wear_time_start = "07:00:00",
    valid_wear_time_end = "22:00:00",
    start_first_bin = 0,
    start_last_bin = 10000,
    bin_width = 500
    )$df_all_metrics
recap <- average_results(data = summary_by_day, minimum_wear_time = 10, fun  = "median")
create_fig_mx_summary(
    data = recap,
    labels = seq(2500, 12500, 2500)
 )
 }
 
}
