% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pro_actigraph_score.R
\name{compute_pro_actigraph_score}
\alias{compute_pro_actigraph_score}
\title{Compute PROactive monitor-based physical activity score for C-PPAC tool}
\usage{
compute_pro_actigraph_score(
  x,
  quest = c("C-PPAC", "D-PPAC"),
  metric = c("steps", "vmu"),
  fun = c("median", "mean")
)
}
\arguments{
\item{x}{A numeric value that should be the daily median or the daily mean of step count or vector magnitude unit following a measurement of physical activity;
see Gimeno-Santos et al. (2015, online supplement, p.71, doi: 10.1183/09031936.00183014) and Garcia-Aymerich et al. (2021, supplemental material, p.17; doi: 10.1136/thoraxjnl-2020-214554).}

\item{quest}{A character value to indicate for which PROactive questionnaire a score of the amount of physical activity should be computed.}

\item{metric}{A character value to indicate the metric for which the PROactive score should be obtained.}

\item{fun}{A character value to indicate if the metric used in the function is the median or the mean of the results obtained each day of the measurement.}
}
\value{
A numeric value.
}
\description{
This function computes the PROactive activity score based on the daily median or mean of
step count or vector magnitude unit (in counts/min) obtained using an ActiGraph accelerometer.
}
\examples{
compute_pro_actigraph_score(x = 3500, quest = "C-PPAC", metric = "steps", fun = "median")

compute_pro_actigraph_score(x = 340, quest = "C-PPAC", metric = "vmu",  fun = "mean")

}
