% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_update_normalization.R
\name{transcripts_update_normalization}
\alias{transcripts_update_normalization}
\title{Normalize transcriptions}
\usage{
transcripts_update_normalization(
  x,
  path_replacementMatrixCSV = "",
  transcriptNames = NULL,
  forceUpdate = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{path_replacementMatrixCSV}{Character string; path to replacement matrix in CSV format. If empty, the default replacement matrix that comes with the package will be used.}

\item{transcriptNames}{Vector of character strings; Names of the transcripts for which you want to search media files; leave empty if you want to search media for all transcripts in the corpus object.}

\item{forceUpdate}{Logical; If \code{TRUE} transcripts will be normalized in any case, if \code{FALSE} transcripts will be only normalized if there was a modification to the transcript since the last normalization.}
}
\description{
Normalizes the contents of transcriptions in a corpus object using a normalization matrix.
Function returns a corpus object with normalized transcription and updates the original corpus object passed as argument to x.
}
\examples{
library(act)

examplecorpus <- act::transcripts_update_normalization(x=examplecorpus)

}
