% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_textgrid_import.R
\name{textgrid_import}
\alias{textgrid_import}
\title{Import a single 'Praat' '*.TextGrid' file}
\usage{
textgrid_import(input_path)
}
\arguments{
\item{input_path}{Character string; input path of a single 'Praat' '*.TextGrid' file.}
}
\value{
Transcript object.
}
\description{
Import a single 'Praat' '*.TextGrid' file
}
\examples{
library(act)

# Path to the TextGrid that you want to read
path <- system.file("extdata", "examplecorpus", "GAT", "ARG_I_PAR_Beto.TextGrid", package="act")

# To import a TextGrid file of your choice:
\dontrun{
path <- "PATH_TO_AN_EXISTING_TEXTGRID_ON_YOUR_COMPUTER"
}

# Read
t <- act::textgrid_import(input_path=path)

t

}
