\name{acopula-package}
\alias{acopula-package}
\alias{acopula}
\docType{package}
\title{
Modelling dependence with multivariate Archimax (or any user-defined continuous) copulas.
}
\description{
Archimax copulas are mixture of Archimedean and EV copulas. The package provides definitions of several parametric families of generator and dependence function, computes CDF and PDF, estimates parameters, tests for goodness of fit, generates random sample and checks copula properties for custom constructs. In 2-dimensional case explicit formulas for density are used, in the contrary to higher dimensions when all derivatives are linearly approximated. Several non-archimax families (normal, FGM, Plackett) are provided as well. 
}
\details{
\tabular{ll}{
Package: \tab acopula\cr
Type: \tab Package\cr
Version: \tab 0.9.2\cr
Date: \tab 2013-07-23\cr
License: \tab GPL-2\cr
}
Generators, dependence functions and generic copula definition lists are generated by functions named starting with \code{gen}, \code{dep} and \code{cop}, respectively. Definition lists are supplied to functions x\code{Copula} where x stands for \code{p} (probability distribution f., CDF), \code{d} (probability density f., PDF), \code{r} (random sampling), \code{c} (conditional CDF), \code{q} (quantile function), \code{e} (parameter estimation), \code{g} (goodness-of-fit test), \code{is} (copula properties check). 
}
\author{
Tomas Bacigal

Maintainer: Tomas Bacigal <bacigal@math.sk>
}
\references{
\enc{Bacigál}{Bacigal}, T. (2012): Recent tools for modelling dependence with copulas and R. \emph{Forum Statisticum Slovacum} 8(1), 62--67.

\enc{Capéraá}{Caperaa}, P., \enc{Fougéres}{Fougeres}, A.-L., Genest, C. (2000): Bivariate distributions with given extreme value attractor. \emph{J.Multivariate Anal.} 72(1) 30--49.

Mesiar, R., \enc{Jágr}{Jagr}, V. (2012): \eqn{d}-Dimensional dependence functions and Archimax copulas. \emph{Fuzzy Sets and Systems}, in press.

\enc{Bacigál}{Bacigal}, T. (2013): R Package to Handle Archimax or Any User-Defined Continuous Copula Construction. Aggregation Functions in Theory and in Practise. Springer Berlin Heidelberg, 75--84.
}
%~~ Optionally other standard keywords, one per line, from file KEYWORDS in the R documentation directory ~~
\keyword{Archimax}
\keyword{Archimedean}
\keyword{Extreme-Value}
%\seealso{
%}
%\examples{
%}
