% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{acled_old_dummy}
\alias{acled_old_dummy}
\title{A dummy data frame of ACLED events emulating an old format, used in "Keeping your dataset updated" Vignette}
\format{
A data frame:
\describe{
\item{event_id_cnty}{An unique individual identifier by number and country acronym (updated annually)}
\item{event_date}{The day, month and year on which an event took place}
\item{year}{The year in which an event took place}
\item{time_precision}{A numeric code indicating the level of certainty of the date coded for the event}
\item{disorder_type}{Type of disorder associated with the event and sub event type}
\item{event_type}{The type of event}
\item{sub_event_type}{The type of sub-event}
\item{actor1}{The named actor involved in the event. Note: Actor 1 and Actor 2 do not imply directionality (e.g. attacker or defender)}
\item{assoc_actor_1}{The named actor associated with or identifying actor1}
\item{inter1}{A numeric code indicating the type of actor1}
\item{actor2}{The named actor involved in the event. Note: Actor 1 and Actor 2 do not imply directionality (e.g. attacker or defender)}
\item{assoc_actor_2}{The named actor associated with or identifying actor1}
\item{inter2}{A numeric code indicating the type of actor1}
\item{interaction}{A numeric code indicating the interaction between types of actor1 and actor2}
\item{civilian_targeting}{Column referencing the presence of civilian targeting}
\item{iso}{A numeric code for each individual country}
\item{region}{The region of the world where the event took place}
\item{country}{The country in which the event took place}
\item{admin1}{The largest sub-national administrative region in which the event took place}
\item{admin2}{The second largest sub-national administrative region in which the event took place}
\item{admin3}{The third largest sub-national administrative region in which the event took place}
\item{location}{The location in which the event took place}
\item{latitude}{The latitude of the location}
\item{longitude}{The longitude of the location}
\item{geo_precision}{A numeric code indicating the level of certainty of the location coded for the event}
\item{source}{The source of the event report}
\item{source_scale}{The scale (local, regional, national, international) of the source}
\item{notes}{A short description of the event}
\item{fatalities}{The number of reported fatalities which occurred during the event}
\item{tags}{Tags associated with the event.}
\item{timestamp}{Numeric code of time}}
}
\usage{
acled_old_dummy
}
\description{
Small dataset of events in Argentina, purposefully including events which are currently deleted/modified.
}
\seealso{
Other Data: 
\code{\link{acled_codebook}},
\code{\link{acled_countries}},
\code{\link{acled_event_categories}},
\code{\link{acled_interaction_codes}},
\code{\link{acled_multipliers}},
\code{\link{acled_old_deletion_dummy}},
\code{\link{acled_regions}}
}
\concept{Data}
\keyword{datasets}
