% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_api.R
\name{acled_api}
\alias{acled_api}
\title{Request data from ACLED API}
\usage{
acled_api(
  email = NULL,
  key = NULL,
  password = NULL,
  country = NULL,
  regions = NULL,
  start_date = floor_date(Sys.Date(), "year") - years(1),
  end_date = Sys.Date(),
  timestamp = NULL,
  event_types = NULL,
  population = "none",
  inter_numeric = FALSE,
  monadic = FALSE,
  ...,
  acled_access = FALSE,
  prompt = TRUE,
  log = FALSE
)
}
\arguments{
\item{email}{character string. Email associated with your ACLED account registered at \url{https://acleddata.com/}.}

\item{key}{character string. Access key associated with your ACLED account registered at \url{https://acleddata.com/}  (deprecated).}

\item{password}{character string. The password associated with your ACLED account. If NULL, you will be prompted to enter your password interactively.}

\item{country}{character vector. Default is NULL, which will return events for all countries. Pass a vector of countries names to retrieve events from specific countries. The list of ACLED countries. names may be found via acledR::acled_countries.}

\item{regions}{vector of region names (character) or region codes (numeric). Default is NULL, which will return events for all regions.  Pass a vector of regions names or codes to retrieve events from countries. within specific regions. The list of ACLED regions may be found via acledR::acled_regions.}

\item{start_date}{character string. Format 'yyyy-mm-dd'. The earliest date for which to return events. The default is \code{1997-01-01}, which is the earliest date available.}

\item{end_date}{character string. Format 'yyyy-mm-dd'. The latest date for which to return events. The default is Sys.Date(), which is the most present date.}

\item{timestamp}{numerical or character string. Provide a date or datetime written as either a character string of yyyy-mm-dd or as a numeric Unix timestamp to access all events added or updated after that date.}

\item{event_types}{vector of one or more event types (character). Default is NULL, which will return data for all event types. To reurn data for only specific event types, request one or more of the following options (not case sensitive): Battles, Violence against civilians, Protests, Riots, Strategic Developments, and Explosions/Remote violence.}

\item{population}{character. Specify whether to return population estimates for each event. It accepts three options: "none" (default), "best", and "full".}

\item{inter_numeric}{logical. If FALSE (default), interaction code columns (inter1, inter2, and interaction) returned as strings describing the actor types/interactions. If TRUE, the values are returned as numeric values.}

\item{monadic}{logical. If FALSE (default), returns dyadic data. If TRUE, returns monadic actor1 data.}

\item{...}{string. Any additional parameters that users would like to add to their API calls (e.g. interaction or ISO)}

\item{acled_access}{logical. If TRUE (default), you have used the acled_access function and the email and key arguments are not required (deprecated).}

\item{prompt}{logical. If TRUE (default), users will receive an interactive prompt providing information about their call (countries requested, number of estimated events, and number of API calls required) and asking if they want to proceed with the call. If FALSE, the call continues without warning, but the call is split and returns a message specifying how many calls are being made.}

\item{log}{logical. If TRUE, it provides a dataframe with the countries and days requested, and how many calls it entails. The dataframe is provided INSTEAD of the normal ACLED dataset.}
}
\value{
Returns a tibble of of ACLED events.
}
\description{
This function allows users to easily request data from the ACLED API. Users can include variables such as country, regions, dates of interest and the format (monadic or dyadic). The function returns a tibble of the desired ACLED events.
}
\examples{
\dontrun{

# Get all the events coded by ACLED in Argentina from 01/01/2022 until 02/01/2022
# in dyadic-wide form
argen_acled <- acled_api(
   email = "youremail@mail.com", password = "password",
  country = "Argentina", start_date = "2022-01-01", end_date = "2022-02-01"
)

# tibble with all the events from Argentina where each row is one event.
argen_acled

# Get all events coded by ACLED in the Caribbean from 01/01/2022 to 10/01/2022
# in monadic-long form using email and key saved in environment

carib_acled <- acled_api(
  email = "youremail@mail.com", password = "password",
  regions = "Caribbean", start_date = "2022-01-01",
  end_date = "2022-01-10", monadic = TRUE,
)

## Tibble with all the events from the Caribbean where each row is one actor
carib_acled
}
}
\seealso{
\itemize{
\item ACLED API guide. \url{https://acleddata.com/api-documentation/getting-started}
}

Other API and Access: 
\code{\link{acled_access}()},
\code{\link{acled_auth}()},
\code{\link{acled_deletions_api}()},
\code{\link{acled_update}()}
}
\concept{API and Access}
