% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_release_utils.R
\name{download_sqlite_release}
\alias{download_sqlite_release}
\title{Download SQLite file from GitHub release}
\usage{
download_sqlite_release(
  owner,
  repo,
  asset_name,
  dest_dir,
  tag = NULL,
  algo = "sha256",
  token = Sys.getenv("GITHUB_PAT"),
  overwrite = TRUE
)
}
\arguments{
\item{owner}{Repository owner.}

\item{repo}{Repository name.}

\item{asset_name}{Name of the SQLite asset in the release.}

\item{dest_dir}{Local directory where the file should be saved.}

\item{tag}{Optional release tag (e.g., \code{"v1.2.0"}).
If NULL, the latest release is used.}

\item{algo}{Hash algorithm (default: \code{"sha256"}).}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}

\item{overwrite}{Whether to overwrite existing file (default: TRUE).}
}
\value{
Invisibly returns the full path to the downloaded file.
}
\description{
Downloads a SQLite database file from the latest or a specific
GitHub release.
}
\examples{
\dontrun{
download_sqlite_release(
  owner = "myuser",
  repo = "myrepo",
  asset_name = "database.sqlite",
  dest_dir = tempdir()
)
}
}
