% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{intensities}
\alias{intensities}
\title{Physical Activity Intensities}
\usage{
intensities(counts, int_cuts = as.integer(c(100, 760, 2020, 5999)))
}
\arguments{
\item{counts}{Integer vector with accelerometer count values.}

\item{int_cuts}{Numeric vector with four cutpoints from which five intensity 
ranges are derived. For example, \code{int_cuts = c(100, 760, 2020, 5999)} 
creates: 0-99 = intensity 1; 100-759 = intensity level 2; 760-2019 = 
intensity 3; 2020-5998 = intensity 4; >= 5999 = intensity 5.}
}
\value{
Integer vector of length 16 in which the first eight values are 
minutes in intensities 1, 2, 3, 4, 5, 2-3, 4-5, and 2-5, and the next eight 
are counts accumulated during time spent in each of those intensities.
}
\description{
Given a vector of accelerometer count values, calculates time spent in 5 
mutually exclusive user-defined intensity levels (typically representing
sedentary, light, lifestyle, moderate, and vigorous) as well as the total 
counts accumulated in various intensities. Non-wear time should be removed 
from \code{counts} before calling \code{intensities} to avoid overestimating 
sedentary time.
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005
counts.part1 <- unidata[unidata[, "seqn"] == 21005, "paxinten"]

# Create vector of counts during valid wear time only
counts.part1.wear <- counts.part1[weartime(counts = counts.part1) == 1]

# Calculate physical activity intensity variables
intensity.variables <- intensities(counts = counts.part1.wear)


}
