% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carf.R
\name{carf_calc_dig}
\alias{carf_calc_dig}
\title{Calculate check digit for CARF}
\usage{
carf_calc_dig(id, build = FALSE, verify = TRUE)
}
\arguments{
\item{id}{Lawsuit number (including trailing zeros), excluding
the check digit.}

\item{build}{Whether or not the function return the complete number
(or only the check digits)?}

\item{verify}{Verify if number is well formed (gives error if it's not)}
}
\value{
The check digits or the complete identification number
}
\description{
Returns the check digit of a CARF number or full number with
the check digit.
}
\examples{
{
  carf_calc_dig("10120.008427/2003", build = TRUE)
  carf_calc_dig("15374.002430/99", build = FALSE)
  carf_calc_dig(c("101200084272003", "1537400243099"))
}
}
