% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processRemoteImage.R
\name{processRemoteImage}
\alias{processRemoteImage}
\title{Process Remote Image}
\usage{
processRemoteImage(img_url = NULL, language = "English",
  profile = c("documentConversion", "documentArchiving", "textExtraction",
  "fieldLevelRecognition", "barcodeRecognition"), textType = c("normal",
  "typewriter", "matrix", "index", "ocrA", "ocrB", "e13b", "cmc7", "gothic"),
  imageSource = c("auto", "photo", "scanner"),
  correctOrientation = c("true", "false"), correctSkew = c("true", "false"),
  readBarcodes = c("false", "true"), exportFormat = c("txt",
  "txtUnstructured", "rtf", "docx", "xlsx", "pptx", "pdfSearchable",
  "pdfTextAndImages", "pdfa", "xml", "xmlForCorrectedImage", "alto"),
  description = NULL, pdfPassword = NULL, ...)
}
\arguments{
\item{img_url}{Required; url to remote image}

\item{language}{Optional; default: English}

\item{profile}{String. Optional; default: \code{documentConversion}
Options: \code{documentConversion, documentArchiving, textExtraction, fieldLevelRecognition, barcodeRecognition}}

\item{textType}{String. Optional; default: \code{normal}. Specifies the type of the text on a page.
Options: \code{normal, typewriter, matrix, index, ocrA,ocrB, e13b,cmc7, gothic}}

\item{imageSource}{String. Optional; default: \code{auto}
Options: \code{auto, photo, scanner}}

\item{correctOrientation}{String. Optional; default: \code{true}. 
Options: \code{true} or \code{false}}

\item{correctSkew}{String. Optional; default: \code{true}.
Options: \code{true} or \code{false}}

\item{readBarcodes}{Optional; default:}

\item{exportFormat}{Optional; default: txt. Must be one of the following: txt, rtf, docx, xlsx, pptx, pdfSearchable, pdfTextAndImages, pdfa, xml, alto}

\item{description}{Optional; default: ""}

\item{pdfPassword}{Optional; default: NULL}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_GET}}.}
}
\value{
Data frame with details of the task associated with the submitted Remote Image
}
\description{
This function gets Information about a particular application
}
\examples{
\dontrun{
processRemoteImage(img_url="img_url")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/processRemoteImage/}
}
