% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Truncate_QSM.R
\docType{methods}
\name{Truncate_QSM}
\alias{Truncate_QSM}
\alias{Truncate_QSM,aRchi-method}
\title{Truncate a QSM}
\usage{
Truncate_QSM(
  aRchi,
  threshold = NULL,
  Keepdaughters = FALSE,
  plotresult = FALSE
)

\S4method{Truncate_QSM}{aRchi}(
  aRchi,
  threshold = NULL,
  Keepdaughters = FALSE,
  plotresult = FALSE
)
}
\arguments{
\item{aRchi}{an object of class aRchi with at least a QSM and a Paths table.}

\item{threshold}{numeric. The radius threshold in meter.}

\item{Keepdaughters}{logical (default = \code{FALSE}). Keep the daughters of the last segment retained even if they are lower than the threshold.}

\item{plotresult}{logical (default = \code{FALSE}). Show the results in a 3d plot if \code{TRUE}}
}
\value{
An aRchi file with the QSM truncated
}
\description{
Truncate a QSM at a radius threshold
}
\details{
The threshold is applied to a whole segments. In other word, if a segment has at least one cylinder lower than the threshold it is removed as well as everything upstream (except the direct daughters if \code{Keepdaughters=TRUE}).
}
\examples{
\donttest{
# Read an aRchifile with a QSM and paths tables.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Truncate the QSM: 5cm radius threshold
Truncated_Tree1_aRchi=Truncate_QSM(Tree1_aRchi,plotresult = TRUE,threshold = 0.05)
}
}
\seealso{
\code{\link{Clean_QSM}} to clean a QSM of an object aRchi.
}
