% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_zelig_mi}
\alias{to_zelig_mi}
\title{Bundle Multiply Imputed Data Sets into an Object for Zelig}
\usage{
to_zelig_mi(...)
}
\arguments{
\item{...}{a set of \code{data.frame}'s}
}
\value{
an \code{mi} object composed of a list of data frames.
}
\description{
This object prepares multiply imputed data sets so they can be used by
  \code{zelig}.
}
\note{
This function creates a list of \code{data.frame} objects, which
  resembles the storage of imputed data sets in the \code{amelia} object.
}
\examples{
# create datasets
n <- 100
x1 <- runif(n)
x2 <- runif(n)
y <- rnorm(n)
data.1 <- data.frame(y = y, x = x1)
data.2 <- data.frame(y = y, x = x2)

# merge datasets into one object as if imputed datasets

mi.out <- to_zelig_mi(data.1, data.2)

# pass object in place of data argument
z.out <- zelig(y ~ x, model = "ls", data = mi.out)
}
\author{
Matt Owen, James Honaker, and Christopher Gandrud
}
