\name{seedweight.model}
\alias{seedweight.model}
\title{The SeedWeight model}
\usage{
  seedweight.model(DD, W, B, C)
}
\arguments{
  \item{DD}{: degree days after anthesis}

  \item{W}{: parameter of the model}

  \item{B}{: parameter of the model}

  \item{C}{: parameter of the model}
}
\value{
  Seed Weight for each TT
}
\description{
  The SeedWeight model is a logistic model of grain weight
  over time in wheat. The model was proposed by Darroch &
  Baker (1990) in a study of grain filling in three spring
  wheat genotypes.  This model has a single input variable,
  degree days after anthesis noted DD, and three
  parameters, noted W, B and C. Parameters are estimated
  from observations.
}
\examples{
plot(1:500,seedweight.model(1:500, W=30,B=4,C=0.020),type="l",
   xlab="degree days after anthesis", ylab="grain weight")
}

