% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt.sharp.R
\name{pt.sharp}
\alias{pt.sharp}
\title{Sharp ratio}
\usage{
pt.sharp(r,n,m,rf)
}
\arguments{
\item{r}{:a vector of asset returns}

\item{n}{:number of years}

\item{m}{:number of periods in a year; m = 12 if r is monthly returns}

\item{rf}{:annulized risk-free rate}
}
\description{
The Sharpe Ratio of an asset return is the quotient of the annualized excess
return of the asset minus the annualized risk-free rate over the annualized standard deviation of the
asset return.
}
\examples{
set.seed(20)
rtn <- runif(12,-0.5,1) # generate random number to simulate monthly returns
rfr <- 0.024 # set risk free rate at 2.4\% annual
pt.sharp(rtn,1,12,rfr) # the return is for one year
}
