% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_interaction_analysis_sc.R
\name{sex_interaction_analysis_sc}
\alias{sex_interaction_analysis_sc}
\title{Perform Sex-Phenotype Interaction Analysis for Single-Cell Data}
\usage{
sex_interaction_analysis_sc(
  seurat_obj,
  target_cell_type,
  sex_col = "sex",
  phenotype_col = "status",
  celltype_col = "cell_type",
  min_logfc = 0.25,
  fdr_threshold = 0.05,
  sex_labels = c("F", "M"),
  phenotype_labels = c("WT", "TG")
)
}
\arguments{
\item{seurat_obj}{A Seurat object.}

\item{target_cell_type}{Character. Cell type to analyze.}

\item{sex_col}{Character. Column name for sex (default "sex").}

\item{phenotype_col}{Character. Column name for phenotype (default "status").}

\item{celltype_col}{Character. Column name for cell type (default "cell_type").}

\item{min_logfc}{Numeric. Minimum absolute log fold change (default 0.25).}

\item{fdr_threshold}{Numeric. FDR threshold for significance (default 0.05).}

\item{sex_labels}{Character vector of sex labels (default c("F","M")).}

\item{phenotype_labels}{Character vector of phenotype groups (default c("WT","TG")).}
}
\value{
A list with complete DE results, significant results, and summary statistics.
}
\description{
Performs differential difference analysis for a given cell type
to identify genes modulated by sex-phenotype interactions using limma.
}
